/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CP;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.CX;
import ca.uhn.hl7v2.model.v26.datatype.DR;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.NULLDT;
import ca.uhn.hl7v2.model.v26.datatype.PL;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class FT1
extends AbstractSegment {
    public FT1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Set ID - FT1");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Transaction ID");
            this.add(ST.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(0)}, "Transaction Batch ID");
            this.add(DR.class, true, 1, 53, new Object[]{this.getMessage(), new Integer(0)}, "Transaction Date");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage(), new Integer(0)}, "Transaction Posting Date");
            this.add(IS.class, true, 1, 8, new Object[]{this.getMessage()}, "Transaction Type");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage(), new Integer(132)}, "Transaction Code");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(0)}, "Transaction Description");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage(), new Integer(0)}, "Transaction Description - Alt");
            this.add(NM.class, false, 1, 6, new Object[]{this.getMessage(), new Integer(0)}, "Transaction Quantity");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Transaction Amount - Extended");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Transaction amount - unit");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(49)}, "Department Code");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(72)}, "Insurance Plan ID");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Insurance Amount");
            this.add(PL.class, false, 1, 80, new Object[]{this.getMessage(), new Integer(0)}, "Assigned Patient Location");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage()}, "Fee Schedule");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage()}, "Patient Type");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(51)}, "Diagnosis Code - FT1");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(84)}, "Performed By Code");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Ordered By Code");
            this.add(CP.class, false, 1, 12, new Object[]{this.getMessage(), new Integer(0)}, "Unit Cost");
            this.add(EI.class, false, 1, 427, new Object[]{this.getMessage(), new Integer(0)}, "Filler Order Number");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage(), new Integer(0)}, "Entered By Code");
            this.add(CNE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(88)}, "Procedure Code");
            this.add(CNE.class, false, 0, 705, new Object[]{this.getMessage(), new Integer(340)}, "Procedure Code Modifier");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(339)}, "Advanced Beneficiary Notice Code");
            this.add(CWE.class, false, 1, 705, new Object[]{this.getMessage(), new Integer(476)}, "Medically Necessary Duplicate Procedure Reason");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(549)}, "NDC Code");
            this.add(CX.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(0)}, "Payment Reference ID");
            this.add(SI.class, false, 0, 4, new Object[]{this.getMessage(), new Integer(0)}, "Transaction Reference Key");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating FT1 - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDFT1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getFt11_SetIDFT1() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getTransactionID() {
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getFt12_TransactionID() {
        ST ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getTransactionBatchID() {
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getFt13_TransactionBatchID() {
        ST ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DR getTransactionDate() {
        DR ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DR)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DR getFt14_TransactionDate() {
        DR ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (DR)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getTransactionPostingDate() {
        DTM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public DTM getFt15_TransactionPostingDate() {
        DTM ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (DTM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getTransactionType() {
        IS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getFt16_TransactionType() {
        IS ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getTransactionCode() {
        CWE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getFt17_TransactionCode() {
        CWE ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NULLDT getTransactionDescription() {
        NULLDT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NULLDT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NULLDT getFt18_TransactionDescription() {
        NULLDT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (NULLDT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NULLDT getTransactionDescriptionAlt() {
        NULLDT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NULLDT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NULLDT getFt19_TransactionDescriptionAlt() {
        NULLDT ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NULLDT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getTransactionQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getFt110_TransactionQuantity() {
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getTransactionAmountExtended() {
        CP ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getFt111_TransactionAmountExtended() {
        CP ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getTransactionAmountUnit() {
        CP ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getFt112_TransactionAmountUnit() {
        CP ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getDepartmentCode() {
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getFt113_DepartmentCode() {
        CWE ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getInsurancePlanID() {
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getFt114_InsurancePlanID() {
        CWE ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getInsuranceAmount() {
        CP ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getFt115_InsuranceAmount() {
        CP ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getAssignedPatientLocation() {
        PL ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public PL getFt116_AssignedPatientLocation() {
        PL ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (PL)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getFeeSchedule() {
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getFt117_FeeSchedule() {
        IS ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getPatientType() {
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public IS getFt118_PatientType() {
        IS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (IS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE[] getDiagnosisCodeFT1() {
        CWE[] ret = null;
        try {
            Type[] t = this.getField(19);
            ret = new CWE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CWE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getDiagnosisCodeFT1Reps() {
        Object ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CWE getDiagnosisCodeFT1(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getFt119_DiagnosisCodeFT1(int rep) {
        CWE ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getFt119_DiagnosisCodeFT1Reps() {
        Object ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CWE insertDiagnosisCodeFT1(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(19, rep);
    }

    public CWE insertFt119_DiagnosisCodeFT1(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(19, rep);
    }

    public CWE removeDiagnosisCodeFT1(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(19, rep);
    }

    public CWE removeFt119_DiagnosisCodeFT1(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(19, rep);
    }

    public XCN[] getPerformedByCode() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(20);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPerformedByCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(20);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN getPerformedByCode(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getFt120_PerformedByCode(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(20, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getFt120_PerformedByCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(20);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertPerformedByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(20, rep);
    }

    public XCN insertFt120_PerformedByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(20, rep);
    }

    public XCN removePerformedByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(20, rep);
    }

    public XCN removeFt120_PerformedByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(20, rep);
    }

    public XCN[] getOrderedByCode() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(21);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getOrderedByCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(21);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN getOrderedByCode(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getFt121_OrderedByCode(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(21, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getFt121_OrderedByCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(21);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertOrderedByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(21, rep);
    }

    public XCN insertFt121_OrderedByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(21, rep);
    }

    public XCN removeOrderedByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(21, rep);
    }

    public XCN removeFt121_OrderedByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(21, rep);
    }

    public CP getUnitCost() {
        CP ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CP getFt122_UnitCost() {
        CP ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (CP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public EI getFillerOrderNumber() {
        EI ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (EI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public EI getFt123_FillerOrderNumber() {
        EI ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (EI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN[] getEnteredByCode() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(24);
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (XCN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getEnteredByCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(24);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN getEnteredByCode(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public XCN getFt124_EnteredByCode(int rep) {
        XCN ret = null;
        try {
            Type t = this.getField(24, rep);
            ret = (XCN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getFt124_EnteredByCodeReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(24);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public XCN insertEnteredByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(24, rep);
    }

    public XCN insertFt124_EnteredByCode(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(24, rep);
    }

    public XCN removeEnteredByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(24, rep);
    }

    public XCN removeFt124_EnteredByCode(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(24, rep);
    }

    public CNE getProcedureCode() {
        CNE ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CNE getFt125_ProcedureCode() {
        CNE ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CNE[] getProcedureCodeModifier() {
        CNE[] ret = null;
        try {
            Type[] t = this.getField(26);
            ret = new CNE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CNE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getProcedureCodeModifierReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(26);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CNE getProcedureCodeModifier(int rep) {
        CNE ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CNE getFt126_ProcedureCodeModifier(int rep) {
        CNE ret = null;
        try {
            Type t = this.getField(26, rep);
            ret = (CNE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getFt126_ProcedureCodeModifierReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(26);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CNE insertProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(26, rep);
    }

    public CNE insertFt126_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.insertRepetition(26, rep);
    }

    public CNE removeProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(26, rep);
    }

    public CNE removeFt126_ProcedureCodeModifier(int rep) throws HL7Exception {
        return (CNE)super.removeRepetition(26, rep);
    }

    public CWE getAdvancedBeneficiaryNoticeCode() {
        CWE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getFt127_AdvancedBeneficiaryNoticeCode() {
        CWE ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getMedicallyNecessaryDuplicateProcedureReason() {
        CWE ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getFt128_MedicallyNecessaryDuplicateProcedureReason() {
        CWE ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getNDCCode() {
        CWE ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CWE getFt129_NDCCode() {
        CWE ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (CWE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getPaymentReferenceID() {
        CX ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CX getFt130_PaymentReferenceID() {
        CX ret = null;
        try {
            Type t = this.getField(30, 0);
            ret = (CX)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI[] getTransactionReferenceKey() {
        SI[] ret = null;
        try {
            Type[] t = this.getField(31);
            ret = new SI[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SI)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getTransactionReferenceKeyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(31);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public SI getTransactionReferenceKey(int rep) {
        SI ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getFt131_TransactionReferenceKey(int rep) {
        SI ret = null;
        try {
            Type t = this.getField(31, rep);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getFt131_TransactionReferenceKeyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(31);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public SI insertTransactionReferenceKey(int rep) throws HL7Exception {
        return (SI)super.insertRepetition(31, rep);
    }

    public SI insertFt131_TransactionReferenceKey(int rep) throws HL7Exception {
        return (SI)super.insertRepetition(31, rep);
    }

    public SI removeTransactionReferenceKey(int rep) throws HL7Exception {
        return (SI)super.removeRepetition(31, rep);
    }

    public SI removeFt131_TransactionReferenceKey(int rep) throws HL7Exception {
        return (SI)super.removeRepetition(31, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new DR(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new IS(this.getMessage(), new Integer(17));
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new NULLDT(this.getMessage());
            }
            case 8: {
                return new NULLDT(this.getMessage());
            }
            case 9: {
                return new NM(this.getMessage());
            }
            case 10: {
                return new CP(this.getMessage());
            }
            case 11: {
                return new CP(this.getMessage());
            }
            case 12: {
                return new CWE(this.getMessage());
            }
            case 13: {
                return new CWE(this.getMessage());
            }
            case 14: {
                return new CP(this.getMessage());
            }
            case 15: {
                return new PL(this.getMessage());
            }
            case 16: {
                return new IS(this.getMessage(), new Integer(24));
            }
            case 17: {
                return new IS(this.getMessage(), new Integer(18));
            }
            case 18: {
                return new CWE(this.getMessage());
            }
            case 19: {
                return new XCN(this.getMessage());
            }
            case 20: {
                return new XCN(this.getMessage());
            }
            case 21: {
                return new CP(this.getMessage());
            }
            case 22: {
                return new EI(this.getMessage());
            }
            case 23: {
                return new XCN(this.getMessage());
            }
            case 24: {
                return new CNE(this.getMessage());
            }
            case 25: {
                return new CNE(this.getMessage());
            }
            case 26: {
                return new CWE(this.getMessage());
            }
            case 27: {
                return new CWE(this.getMessage());
            }
            case 28: {
                return new CWE(this.getMessage());
            }
            case 29: {
                return new CX(this.getMessage());
            }
            case 30: {
                return new SI(this.getMessage());
            }
        }
        return null;
    }
}

