/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.EHC_E12_REQUEST;
import ca.uhn.hl7v2.model.v26.segment.CTD;
import ca.uhn.hl7v2.model.v26.segment.IVC;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.PID;
import ca.uhn.hl7v2.model.v26.segment.PSG;
import ca.uhn.hl7v2.model.v26.segment.PSL;
import ca.uhn.hl7v2.model.v26.segment.PSS;
import ca.uhn.hl7v2.model.v26.segment.RFI;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class EHC_E12
extends AbstractMessage {
    public EHC_E12() {
        this(new DefaultModelClassFactory());
    }

    public EHC_E12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, true);
            this.add(RFI.class, true, false);
            this.add(CTD.class, false, true);
            this.add(IVC.class, true, false);
            this.add(PSS.class, true, false);
            this.add(PSG.class, true, false);
            this.add(PID.class, false, false);
            this.add(PSL.class, false, true);
            this.add(EHC_E12_REQUEST.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EHC_E12 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT() {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SFT getSFT(int rep) {
        SFT ret = null;
        try {
            ret = (SFT)this.get("SFT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSFTReps() {
        int reps = -1;
        try {
            reps = this.getAll("SFT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        UAC ret = null;
        try {
            ret = (UAC)this.get("UAC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public UAC getUAC(int rep) {
        UAC ret = null;
        try {
            ret = (UAC)this.get("UAC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getUACReps() {
        int reps = -1;
        try {
            reps = this.getAll("UAC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertUAC(UAC structure, int rep) throws HL7Exception {
        super.insertRepetition("UAC", structure, rep);
    }

    public UAC insertUAC(int rep) throws HL7Exception {
        return (UAC)super.insertRepetition("UAC", rep);
    }

    public UAC removeUAC(int rep) throws HL7Exception {
        return (UAC)super.removeRepetition("UAC", rep);
    }

    public RFI getRFI() {
        RFI ret = null;
        try {
            ret = (RFI)this.get("RFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTD getCTD() {
        CTD ret = null;
        try {
            ret = (CTD)this.get("CTD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTD getCTD(int rep) {
        CTD ret = null;
        try {
            ret = (CTD)this.get("CTD", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCTDReps() {
        int reps = -1;
        try {
            reps = this.getAll("CTD").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCTD(CTD structure, int rep) throws HL7Exception {
        super.insertRepetition("CTD", structure, rep);
    }

    public CTD insertCTD(int rep) throws HL7Exception {
        return (CTD)super.insertRepetition("CTD", rep);
    }

    public CTD removeCTD(int rep) throws HL7Exception {
        return (CTD)super.removeRepetition("CTD", rep);
    }

    public IVC getIVC() {
        IVC ret = null;
        try {
            ret = (IVC)this.get("IVC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PSS getPSS() {
        PSS ret = null;
        try {
            ret = (PSS)this.get("PSS");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PSG getPSG() {
        PSG ret = null;
        try {
            ret = (PSG)this.get("PSG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PSL getPSL() {
        PSL ret = null;
        try {
            ret = (PSL)this.get("PSL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PSL getPSL(int rep) {
        PSL ret = null;
        try {
            ret = (PSL)this.get("PSL", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPSLReps() {
        int reps = -1;
        try {
            reps = this.getAll("PSL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPSL(PSL structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL", structure, rep);
    }

    public PSL insertPSL(int rep) throws HL7Exception {
        return (PSL)super.insertRepetition("PSL", rep);
    }

    public PSL removePSL(int rep) throws HL7Exception {
        return (PSL)super.removeRepetition("PSL", rep);
    }

    public EHC_E12_REQUEST getREQUEST() {
        EHC_E12_REQUEST ret = null;
        try {
            ret = (EHC_E12_REQUEST)this.get("REQUEST");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public EHC_E12_REQUEST getREQUEST(int rep) {
        EHC_E12_REQUEST ret = null;
        try {
            ret = (EHC_E12_REQUEST)this.get("REQUEST", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getREQUESTReps() {
        int reps = -1;
        try {
            reps = this.getAll("REQUEST").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertREQUEST(EHC_E12_REQUEST structure, int rep) throws HL7Exception {
        super.insertRepetition("REQUEST", structure, rep);
    }

    public EHC_E12_REQUEST insertREQUEST(int rep) throws HL7Exception {
        return (EHC_E12_REQUEST)super.insertRepetition("REQUEST", rep);
    }

    public EHC_E12_REQUEST removeREQUEST(int rep) throws HL7Exception {
        return (EHC_E12_REQUEST)super.removeRepetition("REQUEST", rep);
    }
}

