/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_ORDER_PRIOR;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_PATIENT_PRIOR;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_PATIENT_VISIT_PRIOR;
import ca.uhn.hl7v2.model.v26.segment.AL1;
import ca.uhn.hl7v2.model.v26.segment.NK1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OPL_O37_PRIOR_RESULT
extends AbstractGroup {
    public OPL_O37_PRIOR_RESULT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NK1.class, true, true);
            this.add(OPL_O37_PATIENT_PRIOR.class, false, false);
            this.add(OPL_O37_PATIENT_VISIT_PRIOR.class, false, false);
            this.add(AL1.class, false, false);
            this.add(OPL_O37_ORDER_PRIOR.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OPL_O37_PRIOR_RESULT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public NK1 getNK1() {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1(int rep) {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNK1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("NK1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public OPL_O37_PATIENT_PRIOR getPATIENT_PRIOR() {
        OPL_O37_PATIENT_PRIOR ret = null;
        try {
            ret = (OPL_O37_PATIENT_PRIOR)this.get("PATIENT_PRIOR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPL_O37_PATIENT_VISIT_PRIOR getPATIENT_VISIT_PRIOR() {
        OPL_O37_PATIENT_VISIT_PRIOR ret = null;
        try {
            ret = (OPL_O37_PATIENT_VISIT_PRIOR)this.get("PATIENT_VISIT_PRIOR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public AL1 getAL1() {
        AL1 ret = null;
        try {
            ret = (AL1)this.get("AL1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPL_O37_ORDER_PRIOR getORDER_PRIOR() {
        OPL_O37_ORDER_PRIOR ret = null;
        try {
            ret = (OPL_O37_ORDER_PRIOR)this.get("ORDER_PRIOR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OPL_O37_ORDER_PRIOR getORDER_PRIOR(int rep) {
        OPL_O37_ORDER_PRIOR ret = null;
        try {
            ret = (OPL_O37_ORDER_PRIOR)this.get("ORDER_PRIOR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDER_PRIORReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER_PRIOR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER_PRIOR(OPL_O37_ORDER_PRIOR structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_PRIOR", structure, rep);
    }

    public OPL_O37_ORDER_PRIOR insertORDER_PRIOR(int rep) throws HL7Exception {
        return (OPL_O37_ORDER_PRIOR)super.insertRepetition("ORDER_PRIOR", rep);
    }

    public OPL_O37_ORDER_PRIOR removeORDER_PRIOR(int rep) throws HL7Exception {
        return (OPL_O37_ORDER_PRIOR)super.removeRepetition("ORDER_PRIOR", rep);
    }
}

