/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.MFN_M16_MATERIAL_LOCATION;
import ca.uhn.hl7v2.model.v26.group.MFN_M16_PURCHASING_VENDOR;
import ca.uhn.hl7v2.model.v26.group.MFN_M16_STERILIZATION;
import ca.uhn.hl7v2.model.v26.segment.ITM;
import ca.uhn.hl7v2.model.v26.segment.MFE;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M16_MATERIAL_ITEM_RECORD
extends AbstractGroup {
    public MFN_M16_MATERIAL_ITEM_RECORD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false);
            this.add(ITM.class, true, false);
            this.add(NTE.class, false, true);
            this.add(MFN_M16_STERILIZATION.class, false, true);
            this.add(MFN_M16_PURCHASING_VENDOR.class, false, true);
            this.add(MFN_M16_MATERIAL_LOCATION.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M16_MATERIAL_ITEM_RECORD - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public MFE getMFE() {
        MFE ret = null;
        try {
            ret = (MFE)this.get("MFE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ITM getITM() {
        ITM ret = null;
        try {
            ret = (ITM)this.get("ITM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public MFN_M16_STERILIZATION getSTERILIZATION() {
        MFN_M16_STERILIZATION ret = null;
        try {
            ret = (MFN_M16_STERILIZATION)this.get("STERILIZATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M16_STERILIZATION getSTERILIZATION(int rep) {
        MFN_M16_STERILIZATION ret = null;
        try {
            ret = (MFN_M16_STERILIZATION)this.get("STERILIZATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSTERILIZATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("STERILIZATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSTERILIZATION(MFN_M16_STERILIZATION structure, int rep) throws HL7Exception {
        super.insertRepetition("STERILIZATION", structure, rep);
    }

    public MFN_M16_STERILIZATION insertSTERILIZATION(int rep) throws HL7Exception {
        return (MFN_M16_STERILIZATION)super.insertRepetition("STERILIZATION", rep);
    }

    public MFN_M16_STERILIZATION removeSTERILIZATION(int rep) throws HL7Exception {
        return (MFN_M16_STERILIZATION)super.removeRepetition("STERILIZATION", rep);
    }

    public MFN_M16_PURCHASING_VENDOR getPURCHASING_VENDOR() {
        MFN_M16_PURCHASING_VENDOR ret = null;
        try {
            ret = (MFN_M16_PURCHASING_VENDOR)this.get("PURCHASING_VENDOR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M16_PURCHASING_VENDOR getPURCHASING_VENDOR(int rep) {
        MFN_M16_PURCHASING_VENDOR ret = null;
        try {
            ret = (MFN_M16_PURCHASING_VENDOR)this.get("PURCHASING_VENDOR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPURCHASING_VENDORReps() {
        int reps = -1;
        try {
            reps = this.getAll("PURCHASING_VENDOR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPURCHASING_VENDOR(MFN_M16_PURCHASING_VENDOR structure, int rep) throws HL7Exception {
        super.insertRepetition("PURCHASING_VENDOR", structure, rep);
    }

    public MFN_M16_PURCHASING_VENDOR insertPURCHASING_VENDOR(int rep) throws HL7Exception {
        return (MFN_M16_PURCHASING_VENDOR)super.insertRepetition("PURCHASING_VENDOR", rep);
    }

    public MFN_M16_PURCHASING_VENDOR removePURCHASING_VENDOR(int rep) throws HL7Exception {
        return (MFN_M16_PURCHASING_VENDOR)super.removeRepetition("PURCHASING_VENDOR", rep);
    }

    public MFN_M16_MATERIAL_LOCATION getMATERIAL_LOCATION() {
        MFN_M16_MATERIAL_LOCATION ret = null;
        try {
            ret = (MFN_M16_MATERIAL_LOCATION)this.get("MATERIAL_LOCATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M16_MATERIAL_LOCATION getMATERIAL_LOCATION(int rep) {
        MFN_M16_MATERIAL_LOCATION ret = null;
        try {
            ret = (MFN_M16_MATERIAL_LOCATION)this.get("MATERIAL_LOCATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMATERIAL_LOCATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("MATERIAL_LOCATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMATERIAL_LOCATION(MFN_M16_MATERIAL_LOCATION structure, int rep) throws HL7Exception {
        super.insertRepetition("MATERIAL_LOCATION", structure, rep);
    }

    public MFN_M16_MATERIAL_LOCATION insertMATERIAL_LOCATION(int rep) throws HL7Exception {
        return (MFN_M16_MATERIAL_LOCATION)super.insertRepetition("MATERIAL_LOCATION", rep);
    }

    public MFN_M16_MATERIAL_LOCATION removeMATERIAL_LOCATION(int rep) throws HL7Exception {
        return (MFN_M16_MATERIAL_LOCATION)super.removeRepetition("MATERIAL_LOCATION", rep);
    }
}

