/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.segment.PSG;
import ca.uhn.hl7v2.model.v26.segment.PSL;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class EHC_E02_PSG
extends AbstractGroup {
    public EHC_E02_PSG(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PSG.class, true, false);
            this.add(PSL.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EHC_E02_PSG - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public PSG getPSG() {
        PSG ret = null;
        try {
            ret = (PSG)this.get("PSG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PSL getPSL() {
        PSL ret = null;
        try {
            ret = (PSL)this.get("PSL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PSL getPSL(int rep) {
        PSL ret = null;
        try {
            ret = (PSL)this.get("PSL", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPSLReps() {
        int reps = -1;
        try {
            reps = this.getAll("PSL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPSL(PSL structure, int rep) throws HL7Exception {
        super.insertRepetition("PSL", structure, rep);
    }

    public PSL insertPSL(int rep) throws HL7Exception {
        return (PSL)super.insertRepetition("PSL", rep);
    }

    public PSL removePSL(int rep) throws HL7Exception {
        return (PSL)super.removeRepetition("PSL", rep);
    }
}

