/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.DFT_P03_OBSERVATION;
import ca.uhn.hl7v2.model.v26.group.DFT_P03_ORDER;
import ca.uhn.hl7v2.model.v26.group.DFT_P03_TIMING_QUANTITY;
import ca.uhn.hl7v2.model.v26.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class DFT_P03_COMMON_ORDER
extends AbstractGroup {
    public DFT_P03_COMMON_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, false, false);
            this.add(DFT_P03_TIMING_QUANTITY.class, false, true);
            this.add(DFT_P03_ORDER.class, false, false);
            this.add(DFT_P03_OBSERVATION.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DFT_P03_COMMON_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DFT_P03_TIMING_QUANTITY getTIMING_QUANTITY() {
        DFT_P03_TIMING_QUANTITY ret = null;
        try {
            ret = (DFT_P03_TIMING_QUANTITY)this.get("TIMING_QUANTITY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DFT_P03_TIMING_QUANTITY getTIMING_QUANTITY(int rep) {
        DFT_P03_TIMING_QUANTITY ret = null;
        try {
            ret = (DFT_P03_TIMING_QUANTITY)this.get("TIMING_QUANTITY", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMING_QUANTITYReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING_QUANTITY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING_QUANTITY(DFT_P03_TIMING_QUANTITY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QUANTITY", structure, rep);
    }

    public DFT_P03_TIMING_QUANTITY insertTIMING_QUANTITY(int rep) throws HL7Exception {
        return (DFT_P03_TIMING_QUANTITY)super.insertRepetition("TIMING_QUANTITY", rep);
    }

    public DFT_P03_TIMING_QUANTITY removeTIMING_QUANTITY(int rep) throws HL7Exception {
        return (DFT_P03_TIMING_QUANTITY)super.removeRepetition("TIMING_QUANTITY", rep);
    }

    public DFT_P03_ORDER getORDER() {
        DFT_P03_ORDER ret = null;
        try {
            ret = (DFT_P03_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DFT_P03_OBSERVATION getOBSERVATION() {
        DFT_P03_OBSERVATION ret = null;
        try {
            ret = (DFT_P03_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DFT_P03_OBSERVATION getOBSERVATION(int rep) {
        DFT_P03_OBSERVATION ret = null;
        try {
            ret = (DFT_P03_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(DFT_P03_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public DFT_P03_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (DFT_P03_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public DFT_P03_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (DFT_P03_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }
}

