/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.model.v26.datatype.TX;
import ca.uhn.log.HapiLogFactory;

public class PRL
extends AbstractType
implements Composite {
    private Type[] data;

    public PRL(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[3];
        this.data[0] = new CWE(this.getMessage());
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new TX(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CWE getParentObservationIdentifier() {
        CWE ret = null;
        try {
            ret = (CWE)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CWE getPrl1_ParentObservationIdentifier() {
        CWE ret = null;
        try {
            ret = (CWE)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getParentObservationSubIdentifier() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getPrl2_ParentObservationSubIdentifier() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TX getParentObservationValueDescriptor() {
        TX ret = null;
        try {
            ret = (TX)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TX getPrl3_ParentObservationValueDescriptor() {
        TX ret = null;
        try {
            ret = (TX)this.getComponent(2);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

