/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.CQ;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.SRT;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RCP
extends AbstractSegment {
    public RCP(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Query Priority");
            this.add(CQ.class, false, 1, 10, new Object[]{this.getMessage(), new Integer(126)}, "Quantity Limited Request");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage(), new Integer(394)}, "Response Modality");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Execution and Delivery Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Modify Indicator");
            this.add(SRT.class, false, 0, 512, new Object[]{this.getMessage(), new Integer(0)}, "Sort-by Field");
            this.add(ID.class, false, 0, 256, new Object[]{this.getMessage()}, "Segment group inclusion");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RCP - this is probably a bug in the source code generator.", e);
        }
    }

    public ID getQueryPriority() {
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getRcp1_QueryPriority() {
        ID ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getQuantityLimitedRequest() {
        CQ ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CQ getRcp2_QuantityLimitedRequest() {
        CQ ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CQ)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getResponseModality() {
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getRcp3_ResponseModality() {
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getExecutionAndDeliveryTime() {
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getRcp4_ExecutionAndDeliveryTime() {
        TS ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getModifyIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getRcp5_ModifyIndicator() {
        ID ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SRT[] getSortByField() {
        SRT[] ret = null;
        try {
            Type[] t = this.getField(6);
            ret = new SRT[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (SRT)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getSortByFieldReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public SRT getSortByField(int rep) {
        SRT ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (SRT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SRT getRcp6_SortByField(int rep) {
        SRT ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (SRT)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRcp6_SortByFieldReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public SRT insertSortByField(int rep) throws HL7Exception {
        return (SRT)super.insertRepetition(6, rep);
    }

    public SRT insertRcp6_SortByField(int rep) throws HL7Exception {
        return (SRT)super.insertRepetition(6, rep);
    }

    public SRT removeSortByField(int rep) throws HL7Exception {
        return (SRT)super.removeRepetition(6, rep);
    }

    public SRT removeRcp6_SortByField(int rep) throws HL7Exception {
        return (SRT)super.removeRepetition(6, rep);
    }

    public ID[] getSegmentGroupInclusion() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ID)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getSegmentGroupInclusionReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public ID getSegmentGroupInclusion(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getRcp7_SegmentGroupInclusion(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getRcp7_SegmentGroupInclusionReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public ID insertSegmentGroupInclusion(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID insertRcp7_SegmentGroupInclusion(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID removeSegmentGroupInclusion(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    public ID removeRcp7_SegmentGroupInclusion(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(91));
            }
            case 1: {
                return new CQ(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(395));
            }
            case 5: {
                return new SRT(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(0));
            }
        }
        return null;
    }
}

