/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.SQM_S25_RESOURCES;
import ca.uhn.hl7v2.model.v251.segment.APR;
import ca.uhn.hl7v2.model.v251.segment.ARQ;
import ca.uhn.hl7v2.model.v251.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class SQM_S25_REQUEST
extends AbstractGroup {
    public SQM_S25_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ARQ.class, true, false);
            this.add(APR.class, false, false);
            this.add(PID.class, false, false);
            this.add(SQM_S25_RESOURCES.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating SQM_S25_REQUEST - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ARQ getARQ() {
        ARQ ret = null;
        try {
            ret = (ARQ)this.get("ARQ");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public APR getAPR() {
        APR ret = null;
        try {
            ret = (APR)this.get("APR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SQM_S25_RESOURCES getRESOURCES() {
        SQM_S25_RESOURCES ret = null;
        try {
            ret = (SQM_S25_RESOURCES)this.get("RESOURCES");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public SQM_S25_RESOURCES getRESOURCES(int rep) {
        SQM_S25_RESOURCES ret = null;
        try {
            ret = (SQM_S25_RESOURCES)this.get("RESOURCES", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRESOURCESReps() {
        int reps = -1;
        try {
            reps = this.getAll("RESOURCES").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRESOURCES(SQM_S25_RESOURCES structure, int rep) throws HL7Exception {
        super.insertRepetition("RESOURCES", structure, rep);
    }

    public SQM_S25_RESOURCES insertRESOURCES(int rep) throws HL7Exception {
        return (SQM_S25_RESOURCES)super.insertRepetition("RESOURCES", rep);
    }

    public SQM_S25_RESOURCES removeRESOURCES(int rep) throws HL7Exception {
        return (SQM_S25_RESOURCES)super.removeRepetition("RESOURCES", rep);
    }
}

