/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.RAS_O17_ADMINISTRATION;
import ca.uhn.hl7v2.model.v251.group.RAS_O17_ENCODING;
import ca.uhn.hl7v2.model.v251.group.RAS_O17_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v251.group.RAS_O17_TIMING;
import ca.uhn.hl7v2.model.v251.segment.CTI;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RAS_O17_ORDER
extends AbstractGroup {
    public RAS_O17_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RAS_O17_TIMING.class, false, true);
            this.add(RAS_O17_ORDER_DETAIL.class, false, false);
            this.add(RAS_O17_ENCODING.class, false, false);
            this.add(RAS_O17_ADMINISTRATION.class, true, true);
            this.add(CTI.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RAS_O17_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O17_TIMING getTIMING() {
        RAS_O17_TIMING ret = null;
        try {
            ret = (RAS_O17_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O17_TIMING getTIMING(int rep) {
        RAS_O17_TIMING ret = null;
        try {
            ret = (RAS_O17_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING(RAS_O17_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public RAS_O17_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RAS_O17_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RAS_O17_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RAS_O17_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RAS_O17_ORDER_DETAIL getORDER_DETAIL() {
        RAS_O17_ORDER_DETAIL ret = null;
        try {
            ret = (RAS_O17_ORDER_DETAIL)this.get("ORDER_DETAIL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O17_ENCODING getENCODING() {
        RAS_O17_ENCODING ret = null;
        try {
            ret = (RAS_O17_ENCODING)this.get("ENCODING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O17_ADMINISTRATION getADMINISTRATION() {
        RAS_O17_ADMINISTRATION ret = null;
        try {
            ret = (RAS_O17_ADMINISTRATION)this.get("ADMINISTRATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O17_ADMINISTRATION getADMINISTRATION(int rep) {
        RAS_O17_ADMINISTRATION ret = null;
        try {
            ret = (RAS_O17_ADMINISTRATION)this.get("ADMINISTRATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getADMINISTRATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("ADMINISTRATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertADMINISTRATION(RAS_O17_ADMINISTRATION structure, int rep) throws HL7Exception {
        super.insertRepetition("ADMINISTRATION", structure, rep);
    }

    public RAS_O17_ADMINISTRATION insertADMINISTRATION(int rep) throws HL7Exception {
        return (RAS_O17_ADMINISTRATION)super.insertRepetition("ADMINISTRATION", rep);
    }

    public RAS_O17_ADMINISTRATION removeADMINISTRATION(int rep) throws HL7Exception {
        return (RAS_O17_ADMINISTRATION)super.removeRepetition("ADMINISTRATION", rep);
    }

    public CTI getCTI() {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTI getCTI(int rep) {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCTIReps() {
        int reps = -1;
        try {
            reps = this.getAll("CTI").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

