/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.PPG_PCG_GOAL_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.PPG_PCG_GOAL_ROLE;
import ca.uhn.hl7v2.model.v251.group.PPG_PCG_ORDER;
import ca.uhn.hl7v2.model.v251.group.PPG_PCG_PROBLEM;
import ca.uhn.hl7v2.model.v251.segment.GOL;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PPG_PCG_GOAL
extends AbstractGroup {
    public PPG_PCG_GOAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(GOL.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PPG_PCG_GOAL_ROLE.class, false, true);
            this.add(PPG_PCG_GOAL_OBSERVATION.class, false, true);
            this.add(PPG_PCG_PROBLEM.class, false, true);
            this.add(PPG_PCG_ORDER.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PPG_PCG_GOAL - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public GOL getGOL() {
        GOL ret = null;
        try {
            ret = (GOL)this.get("GOL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PPG_PCG_GOAL_ROLE getGOAL_ROLE() {
        PPG_PCG_GOAL_ROLE ret = null;
        try {
            ret = (PPG_PCG_GOAL_ROLE)this.get("GOAL_ROLE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPG_PCG_GOAL_ROLE getGOAL_ROLE(int rep) {
        PPG_PCG_GOAL_ROLE ret = null;
        try {
            ret = (PPG_PCG_GOAL_ROLE)this.get("GOAL_ROLE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOAL_ROLEReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL_ROLE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL_ROLE(PPG_PCG_GOAL_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_ROLE", structure, rep);
    }

    public PPG_PCG_GOAL_ROLE insertGOAL_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_GOAL_ROLE)super.insertRepetition("GOAL_ROLE", rep);
    }

    public PPG_PCG_GOAL_ROLE removeGOAL_ROLE(int rep) throws HL7Exception {
        return (PPG_PCG_GOAL_ROLE)super.removeRepetition("GOAL_ROLE", rep);
    }

    public PPG_PCG_GOAL_OBSERVATION getGOAL_OBSERVATION() {
        PPG_PCG_GOAL_OBSERVATION ret = null;
        try {
            ret = (PPG_PCG_GOAL_OBSERVATION)this.get("GOAL_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPG_PCG_GOAL_OBSERVATION getGOAL_OBSERVATION(int rep) {
        PPG_PCG_GOAL_OBSERVATION ret = null;
        try {
            ret = (PPG_PCG_GOAL_OBSERVATION)this.get("GOAL_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOAL_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL_OBSERVATION(PPG_PCG_GOAL_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL_OBSERVATION", structure, rep);
    }

    public PPG_PCG_GOAL_OBSERVATION insertGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPG_PCG_GOAL_OBSERVATION)super.insertRepetition("GOAL_OBSERVATION", rep);
    }

    public PPG_PCG_GOAL_OBSERVATION removeGOAL_OBSERVATION(int rep) throws HL7Exception {
        return (PPG_PCG_GOAL_OBSERVATION)super.removeRepetition("GOAL_OBSERVATION", rep);
    }

    public PPG_PCG_PROBLEM getPROBLEM() {
        PPG_PCG_PROBLEM ret = null;
        try {
            ret = (PPG_PCG_PROBLEM)this.get("PROBLEM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPG_PCG_PROBLEM getPROBLEM(int rep) {
        PPG_PCG_PROBLEM ret = null;
        try {
            ret = (PPG_PCG_PROBLEM)this.get("PROBLEM", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEMReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM(PPG_PCG_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", structure, rep);
    }

    public PPG_PCG_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PPG_PCG_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PPG_PCG_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }

    public PPG_PCG_ORDER getORDER() {
        PPG_PCG_ORDER ret = null;
        try {
            ret = (PPG_PCG_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PPG_PCG_ORDER getORDER(int rep) {
        PPG_PCG_ORDER ret = null;
        try {
            ret = (PPG_PCG_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(PPG_PCG_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public PPG_PCG_ORDER insertORDER(int rep) throws HL7Exception {
        return (PPG_PCG_ORDER)super.insertRepetition("ORDER", rep);
    }

    public PPG_PCG_ORDER removeORDER(int rep) throws HL7Exception {
        return (PPG_PCG_ORDER)super.removeRepetition("ORDER", rep);
    }
}

