/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.OUL_R21_CONTAINER;
import ca.uhn.hl7v2.model.v251.group.OUL_R21_OBSERVATION;
import ca.uhn.hl7v2.model.v251.group.OUL_R21_TIMING_QTY;
import ca.uhn.hl7v2.model.v251.segment.CTI;
import ca.uhn.hl7v2.model.v251.segment.NTE;
import ca.uhn.hl7v2.model.v251.segment.OBR;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OUL_R21_ORDER_OBSERVATION
extends AbstractGroup {
    public OUL_R21_ORDER_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OUL_R21_CONTAINER.class, false, false);
            this.add(ORC.class, false, false);
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OUL_R21_TIMING_QTY.class, false, true);
            this.add(OUL_R21_OBSERVATION.class, true, true);
            this.add(CTI.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OUL_R21_ORDER_OBSERVATION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public OUL_R21_CONTAINER getCONTAINER() {
        OUL_R21_CONTAINER ret = null;
        try {
            ret = (OUL_R21_CONTAINER)this.get("CONTAINER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OUL_R21_TIMING_QTY getTIMING_QTY() {
        OUL_R21_TIMING_QTY ret = null;
        try {
            ret = (OUL_R21_TIMING_QTY)this.get("TIMING_QTY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OUL_R21_TIMING_QTY getTIMING_QTY(int rep) {
        OUL_R21_TIMING_QTY ret = null;
        try {
            ret = (OUL_R21_TIMING_QTY)this.get("TIMING_QTY", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMING_QTYReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING_QTY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING_QTY(OUL_R21_TIMING_QTY structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING_QTY", structure, rep);
    }

    public OUL_R21_TIMING_QTY insertTIMING_QTY(int rep) throws HL7Exception {
        return (OUL_R21_TIMING_QTY)super.insertRepetition("TIMING_QTY", rep);
    }

    public OUL_R21_TIMING_QTY removeTIMING_QTY(int rep) throws HL7Exception {
        return (OUL_R21_TIMING_QTY)super.removeRepetition("TIMING_QTY", rep);
    }

    public OUL_R21_OBSERVATION getOBSERVATION() {
        OUL_R21_OBSERVATION ret = null;
        try {
            ret = (OUL_R21_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OUL_R21_OBSERVATION getOBSERVATION(int rep) {
        OUL_R21_OBSERVATION ret = null;
        try {
            ret = (OUL_R21_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(OUL_R21_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public OUL_R21_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OUL_R21_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OUL_R21_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OUL_R21_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public CTI getCTI() {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTI getCTI(int rep) {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCTIReps() {
        int reps = -1;
        try {
            reps = this.getAll("CTI").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

