/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.ORL_O22_OBSERVATION_REQUEST;
import ca.uhn.hl7v2.model.v251.group.ORL_O22_TIMING;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ORL_O22_ORDER
extends AbstractGroup {
    public ORL_O22_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(ORL_O22_TIMING.class, false, true);
            this.add(ORL_O22_OBSERVATION_REQUEST.class, false, false);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORL_O22_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O22_TIMING getTIMING() {
        ORL_O22_TIMING ret = null;
        try {
            ret = (ORL_O22_TIMING)this.get("TIMING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORL_O22_TIMING getTIMING(int rep) {
        ORL_O22_TIMING ret = null;
        try {
            ret = (ORL_O22_TIMING)this.get("TIMING", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getTIMINGReps() {
        int reps = -1;
        try {
            reps = this.getAll("TIMING").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertTIMING(ORL_O22_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public ORL_O22_TIMING insertTIMING(int rep) throws HL7Exception {
        return (ORL_O22_TIMING)super.insertRepetition("TIMING", rep);
    }

    public ORL_O22_TIMING removeTIMING(int rep) throws HL7Exception {
        return (ORL_O22_TIMING)super.removeRepetition("TIMING", rep);
    }

    public ORL_O22_OBSERVATION_REQUEST getOBSERVATION_REQUEST() {
        ORL_O22_OBSERVATION_REQUEST ret = null;
        try {
            ret = (ORL_O22_OBSERVATION_REQUEST)this.get("OBSERVATION_REQUEST");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

