/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.ORF_R04_ORDER;
import ca.uhn.hl7v2.model.v251.group.ORF_R04_PATIENT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class ORF_R04_QUERY_RESPONSE
extends AbstractGroup {
    public ORF_R04_QUERY_RESPONSE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORF_R04_PATIENT.class, false, false);
            this.add(ORF_R04_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating ORF_R04_QUERY_RESPONSE - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORF_R04_PATIENT getPATIENT() {
        ORF_R04_PATIENT ret = null;
        try {
            ret = (ORF_R04_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORF_R04_ORDER getORDER() {
        ORF_R04_ORDER ret = null;
        try {
            ret = (ORF_R04_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ORF_R04_ORDER getORDER(int rep) {
        ORF_R04_ORDER ret = null;
        try {
            ret = (ORF_R04_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(ORF_R04_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public ORF_R04_ORDER insertORDER(int rep) throws HL7Exception {
        return (ORF_R04_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ORF_R04_ORDER removeORDER(int rep) throws HL7Exception {
        return (ORF_R04_ORDER)super.removeRepetition("ORDER", rep);
    }
}

