/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.OML_O35_ORDER;
import ca.uhn.hl7v2.model.v251.segment.SAC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OML_O35_SPECIMEN_CONTAINER
extends AbstractGroup {
    public OML_O35_SPECIMEN_CONTAINER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SAC.class, true, false);
            this.add(OML_O35_ORDER.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OML_O35_SPECIMEN_CONTAINER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public SAC getSAC() {
        SAC ret = null;
        try {
            ret = (SAC)this.get("SAC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O35_ORDER getORDER() {
        OML_O35_ORDER ret = null;
        try {
            ret = (OML_O35_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O35_ORDER getORDER(int rep) {
        OML_O35_ORDER ret = null;
        try {
            ret = (OML_O35_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(OML_O35_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public OML_O35_ORDER insertORDER(int rep) throws HL7Exception {
        return (OML_O35_ORDER)super.insertRepetition("ORDER", rep);
    }

    public OML_O35_ORDER removeORDER(int rep) throws HL7Exception {
        return (OML_O35_ORDER)super.removeRepetition("ORDER", rep);
    }
}

