/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.segment.RDF;
import ca.uhn.hl7v2.model.v25.segment.RDT;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RTB_Z74_ROW_DEFINITION
extends AbstractGroup {
    public RTB_Z74_ROW_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(RDF.class, true, false);
            this.add(RDT.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RTB_Z74_ROW_DEFINITION - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public RDF getRDF() {
        RDF ret = null;
        try {
            ret = (RDF)this.get("RDF");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDT getRDT() {
        RDT ret = null;
        try {
            ret = (RDT)this.get("RDT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDT getRDT(int rep) {
        RDT ret = null;
        try {
            ret = (RDT)this.get("RDT", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRDTReps() {
        int reps = -1;
        try {
            reps = this.getAll("RDT").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRDT(RDT structure, int rep) throws HL7Exception {
        super.insertRepetition("RDT", structure, rep);
    }

    public RDT insertRDT(int rep) throws HL7Exception {
        return (RDT)super.insertRepetition("RDT", rep);
    }

    public RDT removeRDT(int rep) throws HL7Exception {
        return (RDT)super.removeRepetition("RDT", rep);
    }
}

