/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.RDR_RDR_DISPENSE;
import ca.uhn.hl7v2.model.v25.group.RDR_RDR_ENCODING;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RDR_RDR_ORDER
extends AbstractGroup {
    public RDR_RDR_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RDR_RDR_ENCODING.class, false, false);
            this.add(RDR_RDR_DISPENSE.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RDR_RDR_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDR_RDR_ENCODING getENCODING() {
        RDR_RDR_ENCODING ret = null;
        try {
            ret = (RDR_RDR_ENCODING)this.get("ENCODING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDR_RDR_DISPENSE getDISPENSE() {
        RDR_RDR_DISPENSE ret = null;
        try {
            ret = (RDR_RDR_DISPENSE)this.get("DISPENSE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RDR_RDR_DISPENSE getDISPENSE(int rep) {
        RDR_RDR_DISPENSE ret = null;
        try {
            ret = (RDR_RDR_DISPENSE)this.get("DISPENSE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDISPENSEReps() {
        int reps = -1;
        try {
            reps = this.getAll("DISPENSE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertDISPENSE(RDR_RDR_DISPENSE structure, int rep) throws HL7Exception {
        super.insertRepetition("DISPENSE", structure, rep);
    }

    public RDR_RDR_DISPENSE insertDISPENSE(int rep) throws HL7Exception {
        return (RDR_RDR_DISPENSE)super.insertRepetition("DISPENSE", rep);
    }

    public RDR_RDR_DISPENSE removeDISPENSE(int rep) throws HL7Exception {
        return (RDR_RDR_DISPENSE)super.removeRepetition("DISPENSE", rep);
    }
}

