/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.PGL_PC6_ORDER_OBSERVATION;
import ca.uhn.hl7v2.model.v25.segment.Hxx;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.OBR;
import ca.uhn.hl7v2.model.v25.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PGL_PC6_ORDER_DETAIL
extends AbstractGroup {
    public PGL_PC6_ORDER_DETAIL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false);
            this.add(Hxx.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PGL_PC6_ORDER_OBSERVATION.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PGL_PC6_ORDER_DETAIL - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public OBR getOBR() {
        OBR ret = null;
        try {
            ret = (OBR)this.get("OBR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public Hxx getHxx() {
        Hxx ret = null;
        try {
            ret = (Hxx)this.get("Hxx");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PGL_PC6_ORDER_OBSERVATION getORDER_OBSERVATION() {
        PGL_PC6_ORDER_OBSERVATION ret = null;
        try {
            ret = (PGL_PC6_ORDER_OBSERVATION)this.get("ORDER_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PGL_PC6_ORDER_OBSERVATION getORDER_OBSERVATION(int rep) {
        PGL_PC6_ORDER_OBSERVATION ret = null;
        try {
            ret = (PGL_PC6_ORDER_OBSERVATION)this.get("ORDER_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDER_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER_OBSERVATION(PGL_PC6_ORDER_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_OBSERVATION", structure, rep);
    }

    public PGL_PC6_ORDER_OBSERVATION insertORDER_OBSERVATION(int rep) throws HL7Exception {
        return (PGL_PC6_ORDER_OBSERVATION)super.insertRepetition("ORDER_OBSERVATION", rep);
    }

    public PGL_PC6_ORDER_OBSERVATION removeORDER_OBSERVATION(int rep) throws HL7Exception {
        return (PGL_PC6_ORDER_OBSERVATION)super.removeRepetition("ORDER_OBSERVATION", rep);
    }
}

