/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v25.group.OML_O21_ORDER_PRIOR;
import ca.uhn.hl7v2.model.v25.group.OML_O21_PATIENT_PRIOR;
import ca.uhn.hl7v2.model.v25.group.OML_O21_PATIENT_VISIT_PRIOR;
import ca.uhn.hl7v2.model.v25.segment.AL1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OML_O21_PRIOR_RESULT
extends AbstractGroup {
    public OML_O21_PRIOR_RESULT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OML_O21_PATIENT_PRIOR.class, false, false);
            this.add(OML_O21_PATIENT_VISIT_PRIOR.class, false, false);
            this.add(AL1.class, false, true);
            this.add(OML_O21_ORDER_PRIOR.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OML_O21_PRIOR_RESULT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public OML_O21_PATIENT_PRIOR getPATIENT_PRIOR() {
        OML_O21_PATIENT_PRIOR ret = null;
        try {
            ret = (OML_O21_PATIENT_PRIOR)this.get("PATIENT_PRIOR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O21_PATIENT_VISIT_PRIOR getPATIENT_VISIT_PRIOR() {
        OML_O21_PATIENT_VISIT_PRIOR ret = null;
        try {
            ret = (OML_O21_PATIENT_VISIT_PRIOR)this.get("PATIENT_VISIT_PRIOR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public AL1 getAL1() {
        AL1 ret = null;
        try {
            ret = (AL1)this.get("AL1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public AL1 getAL1(int rep) {
        AL1 ret = null;
        try {
            ret = (AL1)this.get("AL1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getAL1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("AL1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertAL1(AL1 structure, int rep) throws HL7Exception {
        super.insertRepetition("AL1", structure, rep);
    }

    public AL1 insertAL1(int rep) throws HL7Exception {
        return (AL1)super.insertRepetition("AL1", rep);
    }

    public AL1 removeAL1(int rep) throws HL7Exception {
        return (AL1)super.removeRepetition("AL1", rep);
    }

    public OML_O21_ORDER_PRIOR getORDER_PRIOR() {
        OML_O21_ORDER_PRIOR ret = null;
        try {
            ret = (OML_O21_ORDER_PRIOR)this.get("ORDER_PRIOR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public OML_O21_ORDER_PRIOR getORDER_PRIOR(int rep) {
        OML_O21_ORDER_PRIOR ret = null;
        try {
            ret = (OML_O21_ORDER_PRIOR)this.get("ORDER_PRIOR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDER_PRIORReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER_PRIOR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER_PRIOR(OML_O21_ORDER_PRIOR structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_PRIOR", structure, rep);
    }

    public OML_O21_ORDER_PRIOR insertORDER_PRIOR(int rep) throws HL7Exception {
        return (OML_O21_ORDER_PRIOR)super.insertRepetition("ORDER_PRIOR", rep);
    }

    public OML_O21_ORDER_PRIOR removeORDER_PRIOR(int rep) throws HL7Exception {
        return (OML_O21_ORDER_PRIOR)super.removeRepetition("ORDER_PRIOR", rep);
    }
}

