/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v24.group.RSP_Z86_QUERY_RESPONSE;
import ca.uhn.hl7v2.model.v24.segment.DSC;
import ca.uhn.hl7v2.model.v24.segment.ERR;
import ca.uhn.hl7v2.model.v24.segment.MSA;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.QAK;
import ca.uhn.hl7v2.model.v24.segment.QPD;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RSP_Z86
extends AbstractMessage {
    public RSP_Z86() {
        this(new DefaultModelClassFactory());
    }

    public RSP_Z86(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, false);
            this.add(QAK.class, true, false);
            this.add(QPD.class, true, false);
            this.add(RSP_Z86_QUERY_RESPONSE.class, false, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RSP_Z86 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MSA getMSA() {
        MSA ret = null;
        try {
            ret = (MSA)this.get("MSA");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ERR getERR() {
        ERR ret = null;
        try {
            ret = (ERR)this.get("ERR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public QAK getQAK() {
        QAK ret = null;
        try {
            ret = (QAK)this.get("QAK");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public QPD getQPD() {
        QPD ret = null;
        try {
            ret = (QPD)this.get("QPD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_QUERY_RESPONSE getQUERY_RESPONSE() {
        RSP_Z86_QUERY_RESPONSE ret = null;
        try {
            ret = (RSP_Z86_QUERY_RESPONSE)this.get("QUERY_RESPONSE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RSP_Z86_QUERY_RESPONSE getQUERY_RESPONSE(int rep) {
        RSP_Z86_QUERY_RESPONSE ret = null;
        try {
            ret = (RSP_Z86_QUERY_RESPONSE)this.get("QUERY_RESPONSE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getQUERY_RESPONSEReps() {
        int reps = -1;
        try {
            reps = this.getAll("QUERY_RESPONSE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertQUERY_RESPONSE(RSP_Z86_QUERY_RESPONSE structure, int rep) throws HL7Exception {
        super.insertRepetition("QUERY_RESPONSE", structure, rep);
    }

    public RSP_Z86_QUERY_RESPONSE insertQUERY_RESPONSE(int rep) throws HL7Exception {
        return (RSP_Z86_QUERY_RESPONSE)super.insertRepetition("QUERY_RESPONSE", rep);
    }

    public RSP_Z86_QUERY_RESPONSE removeQUERY_RESPONSE(int rep) throws HL7Exception {
        return (RSP_Z86_QUERY_RESPONSE)super.removeRepetition("QUERY_RESPONSE", rep);
    }

    public DSC getDSC() {
        DSC ret = null;
        try {
            ret = (DSC)this.get("DSC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

