/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.RGV_O15_ENCODING;
import ca.uhn.hl7v2.model.v24.group.RGV_O15_GIVE;
import ca.uhn.hl7v2.model.v24.group.RGV_O15_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RGV_O15_ORDER
extends AbstractGroup {
    public RGV_O15_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RGV_O15_ORDER_DETAIL.class, false, false);
            this.add(RGV_O15_ENCODING.class, false, false);
            this.add(RGV_O15_GIVE.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RGV_O15_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGV_O15_ORDER_DETAIL getORDER_DETAIL() {
        RGV_O15_ORDER_DETAIL ret = null;
        try {
            ret = (RGV_O15_ORDER_DETAIL)this.get("ORDER_DETAIL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGV_O15_ENCODING getENCODING() {
        RGV_O15_ENCODING ret = null;
        try {
            ret = (RGV_O15_ENCODING)this.get("ENCODING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGV_O15_GIVE getGIVE() {
        RGV_O15_GIVE ret = null;
        try {
            ret = (RGV_O15_GIVE)this.get("GIVE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RGV_O15_GIVE getGIVE(int rep) {
        RGV_O15_GIVE ret = null;
        try {
            ret = (RGV_O15_GIVE)this.get("GIVE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGIVEReps() {
        int reps = -1;
        try {
            reps = this.getAll("GIVE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGIVE(RGV_O15_GIVE structure, int rep) throws HL7Exception {
        super.insertRepetition("GIVE", structure, rep);
    }

    public RGV_O15_GIVE insertGIVE(int rep) throws HL7Exception {
        return (RGV_O15_GIVE)super.insertRepetition("GIVE", rep);
    }

    public RGV_O15_GIVE removeGIVE(int rep) throws HL7Exception {
        return (RGV_O15_GIVE)super.removeRepetition("GIVE", rep);
    }
}

