/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v24.group.PRR_PC5_GOAL;
import ca.uhn.hl7v2.model.v24.group.PRR_PC5_ORDER;
import ca.uhn.hl7v2.model.v24.group.PRR_PC5_PROBLEM_OBSERVATION;
import ca.uhn.hl7v2.model.v24.group.PRR_PC5_PROBLEM_PATHWAY;
import ca.uhn.hl7v2.model.v24.group.PRR_PC5_PROBLEM_ROLE;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.PRB;
import ca.uhn.hl7v2.model.v24.segment.VAR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PRR_PC5_PROBLEM
extends AbstractGroup {
    public PRR_PC5_PROBLEM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PRB.class, true, false);
            this.add(NTE.class, false, true);
            this.add(VAR.class, false, true);
            this.add(PRR_PC5_PROBLEM_ROLE.class, false, true);
            this.add(PRR_PC5_PROBLEM_PATHWAY.class, false, true);
            this.add(PRR_PC5_PROBLEM_OBSERVATION.class, false, true);
            this.add(PRR_PC5_GOAL.class, false, true);
            this.add(PRR_PC5_ORDER.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PRR_PC5_PROBLEM - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public PRB getPRB() {
        PRB ret = null;
        try {
            ret = (PRB)this.get("PRB");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE() {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NTE getNTE(int rep) {
        NTE ret = null;
        try {
            ret = (NTE)this.get("NTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("NTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public VAR getVAR() {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VAR getVAR(int rep) {
        VAR ret = null;
        try {
            ret = (VAR)this.get("VAR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getVARReps() {
        int reps = -1;
        try {
            reps = this.getAll("VAR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertVAR(VAR structure, int rep) throws HL7Exception {
        super.insertRepetition("VAR", structure, rep);
    }

    public VAR insertVAR(int rep) throws HL7Exception {
        return (VAR)super.insertRepetition("VAR", rep);
    }

    public VAR removeVAR(int rep) throws HL7Exception {
        return (VAR)super.removeRepetition("VAR", rep);
    }

    public PRR_PC5_PROBLEM_ROLE getPROBLEM_ROLE() {
        PRR_PC5_PROBLEM_ROLE ret = null;
        try {
            ret = (PRR_PC5_PROBLEM_ROLE)this.get("PROBLEM_ROLE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRR_PC5_PROBLEM_ROLE getPROBLEM_ROLE(int rep) {
        PRR_PC5_PROBLEM_ROLE ret = null;
        try {
            ret = (PRR_PC5_PROBLEM_ROLE)this.get("PROBLEM_ROLE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEM_ROLEReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM_ROLE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM_ROLE(PRR_PC5_PROBLEM_ROLE structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM_ROLE", structure, rep);
    }

    public PRR_PC5_PROBLEM_ROLE insertPROBLEM_ROLE(int rep) throws HL7Exception {
        return (PRR_PC5_PROBLEM_ROLE)super.insertRepetition("PROBLEM_ROLE", rep);
    }

    public PRR_PC5_PROBLEM_ROLE removePROBLEM_ROLE(int rep) throws HL7Exception {
        return (PRR_PC5_PROBLEM_ROLE)super.removeRepetition("PROBLEM_ROLE", rep);
    }

    public PRR_PC5_PROBLEM_PATHWAY getPROBLEM_PATHWAY() {
        PRR_PC5_PROBLEM_PATHWAY ret = null;
        try {
            ret = (PRR_PC5_PROBLEM_PATHWAY)this.get("PROBLEM_PATHWAY");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRR_PC5_PROBLEM_PATHWAY getPROBLEM_PATHWAY(int rep) {
        PRR_PC5_PROBLEM_PATHWAY ret = null;
        try {
            ret = (PRR_PC5_PROBLEM_PATHWAY)this.get("PROBLEM_PATHWAY", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEM_PATHWAYReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM_PATHWAY").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM_PATHWAY(PRR_PC5_PROBLEM_PATHWAY structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM_PATHWAY", structure, rep);
    }

    public PRR_PC5_PROBLEM_PATHWAY insertPROBLEM_PATHWAY(int rep) throws HL7Exception {
        return (PRR_PC5_PROBLEM_PATHWAY)super.insertRepetition("PROBLEM_PATHWAY", rep);
    }

    public PRR_PC5_PROBLEM_PATHWAY removePROBLEM_PATHWAY(int rep) throws HL7Exception {
        return (PRR_PC5_PROBLEM_PATHWAY)super.removeRepetition("PROBLEM_PATHWAY", rep);
    }

    public PRR_PC5_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION() {
        PRR_PC5_PROBLEM_OBSERVATION ret = null;
        try {
            ret = (PRR_PC5_PROBLEM_OBSERVATION)this.get("PROBLEM_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRR_PC5_PROBLEM_OBSERVATION getPROBLEM_OBSERVATION(int rep) {
        PRR_PC5_PROBLEM_OBSERVATION ret = null;
        try {
            ret = (PRR_PC5_PROBLEM_OBSERVATION)this.get("PROBLEM_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEM_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM_OBSERVATION(PRR_PC5_PROBLEM_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM_OBSERVATION", structure, rep);
    }

    public PRR_PC5_PROBLEM_OBSERVATION insertPROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (PRR_PC5_PROBLEM_OBSERVATION)super.insertRepetition("PROBLEM_OBSERVATION", rep);
    }

    public PRR_PC5_PROBLEM_OBSERVATION removePROBLEM_OBSERVATION(int rep) throws HL7Exception {
        return (PRR_PC5_PROBLEM_OBSERVATION)super.removeRepetition("PROBLEM_OBSERVATION", rep);
    }

    public PRR_PC5_GOAL getGOAL() {
        PRR_PC5_GOAL ret = null;
        try {
            ret = (PRR_PC5_GOAL)this.get("GOAL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRR_PC5_GOAL getGOAL(int rep) {
        PRR_PC5_GOAL ret = null;
        try {
            ret = (PRR_PC5_GOAL)this.get("GOAL", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGOALReps() {
        int reps = -1;
        try {
            reps = this.getAll("GOAL").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGOAL(PRR_PC5_GOAL structure, int rep) throws HL7Exception {
        super.insertRepetition("GOAL", structure, rep);
    }

    public PRR_PC5_GOAL insertGOAL(int rep) throws HL7Exception {
        return (PRR_PC5_GOAL)super.insertRepetition("GOAL", rep);
    }

    public PRR_PC5_GOAL removeGOAL(int rep) throws HL7Exception {
        return (PRR_PC5_GOAL)super.removeRepetition("GOAL", rep);
    }

    public PRR_PC5_ORDER getORDER() {
        PRR_PC5_ORDER ret = null;
        try {
            ret = (PRR_PC5_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRR_PC5_ORDER getORDER(int rep) {
        PRR_PC5_ORDER ret = null;
        try {
            ret = (PRR_PC5_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORDER(PRR_PC5_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public PRR_PC5_ORDER insertORDER(int rep) throws HL7Exception {
        return (PRR_PC5_ORDER)super.insertRepetition("ORDER", rep);
    }

    public PRR_PC5_ORDER removeORDER(int rep) throws HL7Exception {
        return (PRR_PC5_ORDER)super.removeRepetition("ORDER", rep);
    }
}

