/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.VXR_V03_IN1IN2IN3;
import ca.uhn.hl7v2.model.v231.group.VXR_V03_ORCRXARXROBXNTE;
import ca.uhn.hl7v2.model.v231.group.VXR_V03_PV1PV2;
import ca.uhn.hl7v2.model.v231.segment.MSA;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.model.v231.segment.NK1;
import ca.uhn.hl7v2.model.v231.segment.PD1;
import ca.uhn.hl7v2.model.v231.segment.PID;
import ca.uhn.hl7v2.model.v231.segment.QRD;
import ca.uhn.hl7v2.model.v231.segment.QRF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class VXR_V03
extends AbstractMessage {
    public VXR_V03() {
        this(new DefaultModelClassFactory());
    }

    public VXR_V03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MSA.class, true, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, true);
            this.add(VXR_V03_PV1PV2.class, false, false);
            this.add(VXR_V03_IN1IN2IN3.class, false, true);
            this.add(VXR_V03_ORCRXARXROBXNTE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating VXR_V03 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MSA getMSA() {
        MSA ret = null;
        try {
            ret = (MSA)this.get("MSA");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public QRD getQRD() {
        QRD ret = null;
        try {
            ret = (QRD)this.get("QRD");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public QRF getQRF() {
        QRF ret = null;
        try {
            ret = (QRF)this.get("QRF");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1() {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1(int rep) {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNK1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("NK1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public VXR_V03_PV1PV2 getPV1PV2() {
        VXR_V03_PV1PV2 ret = null;
        try {
            ret = (VXR_V03_PV1PV2)this.get("PV1PV2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXR_V03_IN1IN2IN3 getIN1IN2IN3() {
        VXR_V03_IN1IN2IN3 ret = null;
        try {
            ret = (VXR_V03_IN1IN2IN3)this.get("IN1IN2IN3");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXR_V03_IN1IN2IN3 getIN1IN2IN3(int rep) {
        VXR_V03_IN1IN2IN3 ret = null;
        try {
            ret = (VXR_V03_IN1IN2IN3)this.get("IN1IN2IN3", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getIN1IN2IN3Reps() {
        int reps = -1;
        try {
            reps = this.getAll("IN1IN2IN3").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertIN1IN2IN3(VXR_V03_IN1IN2IN3 structure, int rep) throws HL7Exception {
        super.insertRepetition("IN1IN2IN3", structure, rep);
    }

    public VXR_V03_IN1IN2IN3 insertIN1IN2IN3(int rep) throws HL7Exception {
        return (VXR_V03_IN1IN2IN3)super.insertRepetition("IN1IN2IN3", rep);
    }

    public VXR_V03_IN1IN2IN3 removeIN1IN2IN3(int rep) throws HL7Exception {
        return (VXR_V03_IN1IN2IN3)super.removeRepetition("IN1IN2IN3", rep);
    }

    public VXR_V03_ORCRXARXROBXNTE getORCRXARXROBXNTE() {
        VXR_V03_ORCRXARXROBXNTE ret = null;
        try {
            ret = (VXR_V03_ORCRXARXROBXNTE)this.get("ORCRXARXROBXNTE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXR_V03_ORCRXARXROBXNTE getORCRXARXROBXNTE(int rep) {
        VXR_V03_ORCRXARXROBXNTE ret = null;
        try {
            ret = (VXR_V03_ORCRXARXROBXNTE)this.get("ORCRXARXROBXNTE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCRXARXROBXNTEReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCRXARXROBXNTE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCRXARXROBXNTE(VXR_V03_ORCRXARXROBXNTE structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRXARXROBXNTE", structure, rep);
    }

    public VXR_V03_ORCRXARXROBXNTE insertORCRXARXROBXNTE(int rep) throws HL7Exception {
        return (VXR_V03_ORCRXARXROBXNTE)super.insertRepetition("ORCRXARXROBXNTE", rep);
    }

    public VXR_V03_ORCRXARXROBXNTE removeORCRXARXROBXNTE(int rep) throws HL7Exception {
        return (VXR_V03_ORCRXARXROBXNTE)super.removeRepetition("ORCRXARXROBXNTE", rep);
    }
}

