/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.MFN_M06_MFECM0CM1CM2;
import ca.uhn.hl7v2.model.v231.segment.MFI;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M06
extends AbstractMessage {
    public MFN_M06() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M06(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M06_MFECM0CM1CM2.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M06 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M06_MFECM0CM1CM2 getMFECM0CM1CM2() {
        MFN_M06_MFECM0CM1CM2 ret = null;
        try {
            ret = (MFN_M06_MFECM0CM1CM2)this.get("MFECM0CM1CM2");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M06_MFECM0CM1CM2 getMFECM0CM1CM2(int rep) {
        MFN_M06_MFECM0CM1CM2 ret = null;
        try {
            ret = (MFN_M06_MFECM0CM1CM2)this.get("MFECM0CM1CM2", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMFECM0CM1CM2Reps() {
        int reps = -1;
        try {
            reps = this.getAll("MFECM0CM1CM2").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMFECM0CM1CM2(MFN_M06_MFECM0CM1CM2 structure, int rep) throws HL7Exception {
        super.insertRepetition("MFECM0CM1CM2", structure, rep);
    }

    public MFN_M06_MFECM0CM1CM2 insertMFECM0CM1CM2(int rep) throws HL7Exception {
        return (MFN_M06_MFECM0CM1CM2)super.insertRepetition("MFECM0CM1CM2", rep);
    }

    public MFN_M06_MFECM0CM1CM2 removeMFECM0CM1CM2(int rep) throws HL7Exception {
        return (MFN_M06_MFECM0CM1CM2)super.removeRepetition("MFECM0CM1CM2", rep);
    }
}

