/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v231.group.MFN_M04_MFECDMPRC;
import ca.uhn.hl7v2.model.v231.segment.MFI;
import ca.uhn.hl7v2.model.v231.segment.MSH;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class MFN_M04
extends AbstractMessage {
    public MFN_M04() {
        this(new DefaultModelClassFactory());
    }

    public MFN_M04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(MFI.class, true, false);
            this.add(MFN_M04_MFECDMPRC.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M04 - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFI getMFI() {
        MFI ret = null;
        try {
            ret = (MFI)this.get("MFI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M04_MFECDMPRC getMFECDMPRC() {
        MFN_M04_MFECDMPRC ret = null;
        try {
            ret = (MFN_M04_MFECDMPRC)this.get("MFECDMPRC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public MFN_M04_MFECDMPRC getMFECDMPRC(int rep) {
        MFN_M04_MFECDMPRC ret = null;
        try {
            ret = (MFN_M04_MFECDMPRC)this.get("MFECDMPRC", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getMFECDMPRCReps() {
        int reps = -1;
        try {
            reps = this.getAll("MFECDMPRC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertMFECDMPRC(MFN_M04_MFECDMPRC structure, int rep) throws HL7Exception {
        super.insertRepetition("MFECDMPRC", structure, rep);
    }

    public MFN_M04_MFECDMPRC insertMFECDMPRC(int rep) throws HL7Exception {
        return (MFN_M04_MFECDMPRC)super.insertRepetition("MFECDMPRC", rep);
    }

    public MFN_M04_MFECDMPRC removeMFECDMPRC(int rep) throws HL7Exception {
        return (MFN_M04_MFECDMPRC)super.removeRepetition("MFECDMPRC", rep);
    }
}

