/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v231.group.CSU_C09_ORCOBROBX;
import ca.uhn.hl7v2.model.v231.group.CSU_C09_ORCRXARXR;
import ca.uhn.hl7v2.model.v231.segment.CSS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class CSU_C09_CSSORCOBROBXORCRXARXR
extends AbstractGroup {
    public CSU_C09_CSSORCOBROBXORCRXARXR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CSS.class, false, false);
            this.add(CSU_C09_ORCOBROBX.class, true, true);
            this.add(CSU_C09_ORCRXARXR.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating CSU_C09_CSSORCOBROBXORCRXARXR - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3.1";
    }

    public CSS getCSS() {
        CSS ret = null;
        try {
            ret = (CSS)this.get("CSS");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_ORCOBROBX getORCOBROBX() {
        CSU_C09_ORCOBROBX ret = null;
        try {
            ret = (CSU_C09_ORCOBROBX)this.get("ORCOBROBX");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_ORCOBROBX getORCOBROBX(int rep) {
        CSU_C09_ORCOBROBX ret = null;
        try {
            ret = (CSU_C09_ORCOBROBX)this.get("ORCOBROBX", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCOBROBXReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCOBROBX").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCOBROBX(CSU_C09_ORCOBROBX structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCOBROBX", structure, rep);
    }

    public CSU_C09_ORCOBROBX insertORCOBROBX(int rep) throws HL7Exception {
        return (CSU_C09_ORCOBROBX)super.insertRepetition("ORCOBROBX", rep);
    }

    public CSU_C09_ORCOBROBX removeORCOBROBX(int rep) throws HL7Exception {
        return (CSU_C09_ORCOBROBX)super.removeRepetition("ORCOBROBX", rep);
    }

    public CSU_C09_ORCRXARXR getORCRXARXR() {
        CSU_C09_ORCRXARXR ret = null;
        try {
            ret = (CSU_C09_ORCRXARXR)this.get("ORCRXARXR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_ORCRXARXR getORCRXARXR(int rep) {
        CSU_C09_ORCRXARXR ret = null;
        try {
            ret = (CSU_C09_ORCRXARXR)this.get("ORCRXARXR", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORCRXARXRReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORCRXARXR").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertORCRXARXR(CSU_C09_ORCRXARXR structure, int rep) throws HL7Exception {
        super.insertRepetition("ORCRXARXR", structure, rep);
    }

    public CSU_C09_ORCRXARXR insertORCRXARXR(int rep) throws HL7Exception {
        return (CSU_C09_ORCRXARXR)super.insertRepetition("ORCRXARXR", rep);
    }

    public CSU_C09_ORCRXARXR removeORCRXARXR(int rep) throws HL7Exception {
        return (CSU_C09_ORCRXARXR)super.removeRepetition("ORCRXARXR", rep);
    }
}

