/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v231.datatype;

import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v231.datatype.ST;
import ca.uhn.hl7v2.model.v231.datatype.TSComponentOne;
import ca.uhn.log.HapiLogFactory;

public class TS
extends AbstractType
implements Composite {
    private Type[] data;

    public TS(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[2];
        this.data[0] = new TSComponentOne(this.getMessage());
        this.data[1] = new ST(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public TSComponentOne getTimeOfAnEvent() {
        TSComponentOne ret = null;
        try {
            ret = (TSComponentOne)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public TSComponentOne getTs1_TimeOfAnEvent() {
        TSComponentOne ret = null;
        try {
            ret = (TSComponentOne)this.getComponent(0);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getDegreeOfPrecision() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public ST getTs2_DegreeOfPrecision() {
        ST ret = null;
        try {
            ret = (ST)this.getComponent(1);
        }
        catch (DataTypeException e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }
}

