/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.RRA_O02_ADMINISTRATION;
import ca.uhn.hl7v2.model.v23.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RRA_O02_ORDER
extends AbstractGroup {
    public RRA_O02_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RRA_O02_ADMINISTRATION.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RRA_O02_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RRA_O02_ADMINISTRATION getADMINISTRATION() {
        RRA_O02_ADMINISTRATION ret = null;
        try {
            ret = (RRA_O02_ADMINISTRATION)this.get("ADMINISTRATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RRA_O02_ADMINISTRATION getADMINISTRATION(int rep) {
        RRA_O02_ADMINISTRATION ret = null;
        try {
            ret = (RRA_O02_ADMINISTRATION)this.get("ADMINISTRATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getADMINISTRATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("ADMINISTRATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertADMINISTRATION(RRA_O02_ADMINISTRATION structure, int rep) throws HL7Exception {
        super.insertRepetition("ADMINISTRATION", structure, rep);
    }

    public RRA_O02_ADMINISTRATION insertADMINISTRATION(int rep) throws HL7Exception {
        return (RRA_O02_ADMINISTRATION)super.insertRepetition("ADMINISTRATION", rep);
    }

    public RRA_O02_ADMINISTRATION removeADMINISTRATION(int rep) throws HL7Exception {
        return (RRA_O02_ADMINISTRATION)super.removeRepetition("ADMINISTRATION", rep);
    }
}

