/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.RAS_O01_ENCODING;
import ca.uhn.hl7v2.model.v23.group.RAS_O01_OBSERVATION;
import ca.uhn.hl7v2.model.v23.group.RAS_O01_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v23.segment.CTI;
import ca.uhn.hl7v2.model.v23.segment.ORC;
import ca.uhn.hl7v2.model.v23.segment.RXA;
import ca.uhn.hl7v2.model.v23.segment.RXR;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class RAS_O01_ORDER
extends AbstractGroup {
    public RAS_O01_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false);
            this.add(RAS_O01_ORDER_DETAIL.class, false, false);
            this.add(RAS_O01_ENCODING.class, false, false);
            this.add(RXA.class, true, true);
            this.add(RXR.class, true, false);
            this.add(RAS_O01_OBSERVATION.class, false, true);
            this.add(CTI.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating RAS_O01_ORDER - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public ORC getORC() {
        ORC ret = null;
        try {
            ret = (ORC)this.get("ORC");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_ORDER_DETAIL getORDER_DETAIL() {
        RAS_O01_ORDER_DETAIL ret = null;
        try {
            ret = (RAS_O01_ORDER_DETAIL)this.get("ORDER_DETAIL");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_ENCODING getENCODING() {
        RAS_O01_ENCODING ret = null;
        try {
            ret = (RAS_O01_ENCODING)this.get("ENCODING");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXA getRXA() {
        RXA ret = null;
        try {
            ret = (RXA)this.get("RXA");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RXA getRXA(int rep) {
        RXA ret = null;
        try {
            ret = (RXA)this.get("RXA", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getRXAReps() {
        int reps = -1;
        try {
            reps = this.getAll("RXA").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertRXA(RXA structure, int rep) throws HL7Exception {
        super.insertRepetition("RXA", structure, rep);
    }

    public RXA insertRXA(int rep) throws HL7Exception {
        return (RXA)super.insertRepetition("RXA", rep);
    }

    public RXA removeRXA(int rep) throws HL7Exception {
        return (RXA)super.removeRepetition("RXA", rep);
    }

    public RXR getRXR() {
        RXR ret = null;
        try {
            ret = (RXR)this.get("RXR");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_OBSERVATION getOBSERVATION() {
        RAS_O01_OBSERVATION ret = null;
        try {
            ret = (RAS_O01_OBSERVATION)this.get("OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public RAS_O01_OBSERVATION getOBSERVATION(int rep) {
        RAS_O01_OBSERVATION ret = null;
        try {
            ret = (RAS_O01_OBSERVATION)this.get("OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getOBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertOBSERVATION(RAS_O01_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", structure, rep);
    }

    public RAS_O01_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (RAS_O01_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public RAS_O01_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (RAS_O01_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public CTI getCTI() {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CTI getCTI(int rep) {
        CTI ret = null;
        try {
            ret = (CTI)this.get("CTI", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getCTIReps() {
        int reps = -1;
        try {
            reps = this.getAll("CTI").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

