/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.group.PRR_PC5_PATIENT_VISIT;
import ca.uhn.hl7v2.model.v23.group.PRR_PC5_PROBLEM;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PRR_PC5_PATIENT
extends AbstractGroup {
    public PRR_PC5_PATIENT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PID.class, true, false);
            this.add(PRR_PC5_PATIENT_VISIT.class, false, false);
            this.add(PRR_PC5_PROBLEM.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PRR_PC5_PATIENT - this is probably a bug in the source code generator.", e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRR_PC5_PATIENT_VISIT getPATIENT_VISIT() {
        PRR_PC5_PATIENT_VISIT ret = null;
        try {
            ret = (PRR_PC5_PATIENT_VISIT)this.get("PATIENT_VISIT");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRR_PC5_PROBLEM getPROBLEM() {
        PRR_PC5_PROBLEM ret = null;
        try {
            ret = (PRR_PC5_PROBLEM)this.get("PROBLEM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PRR_PC5_PROBLEM getPROBLEM(int rep) {
        PRR_PC5_PROBLEM ret = null;
        try {
            ret = (PRR_PC5_PROBLEM)this.get("PROBLEM", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getPROBLEMReps() {
        int reps = -1;
        try {
            reps = this.getAll("PROBLEM").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertPROBLEM(PRR_PC5_PROBLEM structure, int rep) throws HL7Exception {
        super.insertRepetition("PROBLEM", structure, rep);
    }

    public PRR_PC5_PROBLEM insertPROBLEM(int rep) throws HL7Exception {
        return (PRR_PC5_PROBLEM)super.insertRepetition("PROBLEM", rep);
    }

    public PRR_PC5_PROBLEM removePROBLEM(int rep) throws HL7Exception {
        return (PRR_PC5_PROBLEM)super.removeRepetition("PROBLEM", rep);
    }
}

