/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_PIP;
import ca.uhn.hl7v2.model.v22.datatype.CM_PLN;
import ca.uhn.hl7v2.model.v22.datatype.CM_SPD;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class PRA
extends AbstractSegment {
    public PRA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ST.class, true, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "PRA - primary key value");
            this.add(CE.class, false, 0, 60, new Object[]{this.getMessage(), new Integer(0)}, "Practitioner group");
            this.add(ID.class, false, 0, 3, new Object[]{this.getMessage()}, "Practitioner Category");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage()}, "Provider Billing");
            this.add(CM_SPD.class, false, 0, 100, new Object[]{this.getMessage(), new Integer(0)}, "Specialty");
            this.add(CM_PLN.class, false, 0, 100, new Object[]{this.getMessage(), new Integer(0)}, "Practitioner ID Numbers");
            this.add(CM_PIP.class, false, 0, 20, new Object[]{this.getMessage(), new Integer(0)}, "Privileges");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PRA - this is probably a bug in the source code generator.", e);
        }
    }

    public ST getPRAPrimaryKeyValue() {
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getPra1_PRAPrimaryKeyValue() {
        ST ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE[] getPractitionerGroup() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(2);
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CE)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPractitionerGroupReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE getPractitionerGroup(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getPra2_PractitionerGroup(int rep) {
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPra2_PractitionerGroupReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CE insertPractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertPra2_PractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removePractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removePra2_PractitionerGroup(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public ID[] getPractitionerCategory() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(3);
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ID)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPractitionerCategoryReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public ID getPractitionerCategory(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPra3_PractitionerCategory(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPra3_PractitionerCategoryReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public ID insertPractitionerCategory(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID insertPra3_PractitionerCategory(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(3, rep);
    }

    public ID removePractitionerCategory(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID removePra3_PractitionerCategory(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(3, rep);
    }

    public ID getProviderBilling() {
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getPra4_ProviderBilling() {
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_SPD[] getSpecialty() {
        CM_SPD[] ret = null;
        try {
            Type[] t = this.getField(5);
            ret = new CM_SPD[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CM_SPD)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getSpecialtyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_SPD getSpecialty(int rep) {
        CM_SPD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (CM_SPD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_SPD getPra5_Specialty(int rep) {
        CM_SPD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (CM_SPD)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPra5_SpecialtyReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_SPD insertSpecialty(int rep) throws HL7Exception {
        return (CM_SPD)super.insertRepetition(5, rep);
    }

    public CM_SPD insertPra5_Specialty(int rep) throws HL7Exception {
        return (CM_SPD)super.insertRepetition(5, rep);
    }

    public CM_SPD removeSpecialty(int rep) throws HL7Exception {
        return (CM_SPD)super.removeRepetition(5, rep);
    }

    public CM_SPD removePra5_Specialty(int rep) throws HL7Exception {
        return (CM_SPD)super.removeRepetition(5, rep);
    }

    public CM_PLN[] getPractitionerIDNumbers() {
        CM_PLN[] ret = null;
        try {
            Type[] t = this.getField(6);
            ret = new CM_PLN[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CM_PLN)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPractitionerIDNumbersReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_PLN getPractitionerIDNumbers(int rep) {
        CM_PLN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CM_PLN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_PLN getPra6_PractitionerIDNumbers(int rep) {
        CM_PLN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (CM_PLN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPra6_PractitionerIDNumbersReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_PLN insertPractitionerIDNumbers(int rep) throws HL7Exception {
        return (CM_PLN)super.insertRepetition(6, rep);
    }

    public CM_PLN insertPra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (CM_PLN)super.insertRepetition(6, rep);
    }

    public CM_PLN removePractitionerIDNumbers(int rep) throws HL7Exception {
        return (CM_PLN)super.removeRepetition(6, rep);
    }

    public CM_PLN removePra6_PractitionerIDNumbers(int rep) throws HL7Exception {
        return (CM_PLN)super.removeRepetition(6, rep);
    }

    public CM_PIP[] getPrivileges() {
        CM_PIP[] ret = null;
        try {
            Type[] t = this.getField(7);
            ret = new CM_PIP[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (CM_PIP)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPrivilegesReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_PIP getPrivileges(int rep) {
        CM_PIP ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CM_PIP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CM_PIP getPra7_Privileges(int rep) {
        CM_PIP ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (CM_PIP)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getPra7_PrivilegesReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public CM_PIP insertPrivileges(int rep) throws HL7Exception {
        return (CM_PIP)super.insertRepetition(7, rep);
    }

    public CM_PIP insertPra7_Privileges(int rep) throws HL7Exception {
        return (CM_PIP)super.insertRepetition(7, rep);
    }

    public CM_PIP removePrivileges(int rep) throws HL7Exception {
        return (CM_PIP)super.removeRepetition(7, rep);
    }

    public CM_PIP removePra7_Privileges(int rep) throws HL7Exception {
        return (CM_PIP)super.removeRepetition(7, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ST(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(186));
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(187));
            }
            case 4: {
                return new CM_SPD(this.getMessage());
            }
            case 5: {
                return new CM_PLN(this.getMessage());
            }
            case 6: {
                return new CM_PIP(this.getMessage());
            }
        }
        return null;
    }
}

