/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class OBX
extends AbstractSegment {
    public OBX(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Set ID - Observational Simple");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage()}, "Value Type");
            this.add(CE.class, true, 1, 80, new Object[]{this.getMessage(), new Integer(0)}, "Observation Identifier");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "Observation Sub-ID");
            this.add(Varies.class, false, 1, 65536, new Object[]{this.getMessage(), new Integer(0)}, "Observation Value");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Units");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "References Range");
            this.add(ID.class, false, 5, 10, new Object[]{this.getMessage()}, "Abnormal Flags");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(0)}, "Probability");
            this.add(ID.class, false, 1, 5, new Object[]{this.getMessage()}, "Nature of Abnormal Test");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage()}, "Observation result status");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Effective date last observation normal values");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage(), new Integer(0)}, "User Defined Access Checks");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage(), new Integer(0)}, "Date / time of the observation");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Producer's ID");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage(), new Integer(0)}, "Responsible Observer");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OBX - this is probably a bug in the source code generator.", e);
        }
    }

    public SI getSetIDObservationalSimple() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public SI getObx1_SetIDObservationalSimple() {
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getValueType() {
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getObx2_ValueType() {
        ID ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getObservationIdentifier() {
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getObx3_ObservationIdentifier() {
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObservationSubID() {
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObx4_ObservationSubID() {
        ST ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public Varies getObservationValue() {
        Varies ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (Varies)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public Varies getObx5_ObservationValue() {
        Varies ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (Varies)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getUnits() {
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getObx6_Units() {
        CE ret = null;
        try {
            Type t = this.getField(6, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getReferencesRange() {
        ST ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObx7_ReferencesRange() {
        ST ret = null;
        try {
            Type t = this.getField(7, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID[] getAbnormalFlags() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(8);
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (ID)t[i];
            }
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getAbnormalFlagsReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public ID getAbnormalFlags(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getObx8_AbnormalFlags(int rep) {
        ID ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public int getObx8_AbnormalFlagsReps() {
        Object ret = null;
        try {
            Type[] t = this.getField(8);
            return t.length;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }

    public ID insertAbnormalFlags(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID insertObx8_AbnormalFlags(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(8, rep);
    }

    public ID removeAbnormalFlags(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public ID removeObx8_AbnormalFlags(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(8, rep);
    }

    public NM getProbability() {
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public NM getObx9_Probability() {
        NM ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (NM)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getNatureOfAbnormalTest() {
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getObx10_NatureOfAbnormalTest() {
        ID ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getObservationResultStatus() {
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ID getObx11_ObservationResultStatus() {
        ID ret = null;
        try {
            Type t = this.getField(11, 0);
            ret = (ID)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getEffectiveDateLastObservationNormalValues() {
        TS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getObx12_EffectiveDateLastObservationNormalValues() {
        TS ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getUserDefinedAccessChecks() {
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public ST getObx13_UserDefinedAccessChecks() {
        ST ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (ST)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getDateTimeOfTheObservation() {
        TS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public TS getObx14_DateTimeOfTheObservation() {
        TS ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (TS)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getProducerSID() {
        CE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CE getObx15_ProducerSID() {
        CE ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (CE)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getResponsibleObserver() {
        CN ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    public CN getObx16_ResponsibleObserver() {
        CN ret = null;
        try {
            Type t = this.getField(16, 0);
            ret = (CN)t;
        }
        catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        }
        catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(125));
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new Varies(this.getMessage());
            }
            case 5: {
                return new CE(this.getMessage());
            }
            case 6: {
                return new ST(this.getMessage());
            }
            case 7: {
                return new ID(this.getMessage(), new Integer(78));
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new ID(this.getMessage(), new Integer(80));
            }
            case 10: {
                return new ID(this.getMessage(), new Integer(85));
            }
            case 11: {
                return new TS(this.getMessage());
            }
            case 12: {
                return new ST(this.getMessage());
            }
            case 13: {
                return new TS(this.getMessage());
            }
            case 14: {
                return new CE(this.getMessage());
            }
            case 15: {
                return new CN(this.getMessage());
            }
        }
        return null;
    }
}

