/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.transport.utils;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.ApplicationException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.business.messaging.hl7.common.HL7ProcessingContext;
import org.wso2.carbon.business.messaging.hl7.common.HL7Utils;
import org.wso2.carbon.business.messaging.hl7.transport.HL7Endpoint;

public class HL7MessageProcessor
implements Application {
    private static final Log log = LogFactory.getLog(HL7MessageProcessor.class);
    private HL7Endpoint endpoint;

    public HL7MessageProcessor(HL7Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Message processMessage(Message message) throws ApplicationException, HL7Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received HL7 message: " + message.toString()));
        }
        HL7ProcessingContext procCtx = this.endpoint.getProcessingContext();
        try {
            MessageContext messageContext = this.endpoint.createMessageContext();
            messageContext.setIncomingTransportName("hl7");
            procCtx.initMessageContext(message, messageContext);
            procCtx.checkConformanceProfile(message);
            messageContext.setEnvelope(this.createEnvelope(message));
            AxisEngine.receive((MessageContext)messageContext);
            return procCtx.handleHL7Result(messageContext, message);
        }
        catch (AxisFault axisFault) {
            return procCtx.createNack(message, "Error while processing the HL7 message through the engine: " + axisFault.getMessage());
        }
        catch (XMLStreamException e) {
            return procCtx.createNack(message, "IO error while processing the HL7 content: " + e.getMessage());
        }
    }

    private SOAPEnvelope createEnvelope(Message message) throws HL7Exception, XMLStreamException {
        SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = fac.getDefaultEnvelope();
        DefaultXMLParser xmlParser = new DefaultXMLParser();
        String xmlDoc = xmlParser.encode(message);
        OMElement messageEl = HL7Utils.generateHL7MessageElement((String)xmlDoc);
        envelope.getBody().addChild((OMNode)messageEl);
        return envelope;
    }

    public boolean canProcess(Message message) {
        return true;
    }
}

