/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.transport.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.business.messaging.hl7.transport.service.HL7TransportService;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class MLLPTransportServiceComponent {
    private static Log log = LogFactory.getLog(MLLPTransportServiceComponent.class);
    private ConfigurationContextService contextService;

    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MLLP Transport bundle is activated");
        }
        try {
            if (this.contextService == null) {
                throw new Exception("ConfigurationContext is not found while loading org.wso2.carbon.business.messaging.hl7.transport bundle");
            }
            ConfigurationContext configContext = this.contextService.getServerConfigContext();
            new TransportPersistenceManager(configContext.getAxisConfiguration()).saveTransportConfiguration("hl7", ctxt.getBundleContext().getBundle().getResource("hl7-transports.xml"));
            HL7TransportService HL7Transport = new HL7TransportService();
            Properties props = new Properties();
            ctxt.getBundleContext().registerService(TransportService.class.getName(), (Object)HL7Transport, (Dictionary)props);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully registered the https transport service");
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating MLLP transport management bundle", e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"MLLP Transport bundle is deactivated ");
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = null;
    }
}

