/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.transport;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionHub;
import ca.uhn.hl7v2.app.Initiator;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.DefaultXMLParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.wso2.carbon.business.messaging.hl7.common.HL7Utils;

public class HL7TransportSender
extends AbstractTransportSender {
    private Parser parser = new DefaultXMLParser();

    public HL7TransportSender() {
        this.parser.setValidationContext((ValidationContext)new NoValidation());
    }

    public void sendMessage(MessageContext messageContext, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        if (targetEPR == null) {
            this.handleException("Unable to send HL7 message without target EPR information");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Send HL7 message using EPR :" + targetEPR));
        }
        OMElement omElement = messageContext.getEnvelope().getBody().getFirstElement().getFirstElement();
        String xmlFormat = omElement.toString();
        Message returnMsg = null;
        Map<String, String> params = this.getURLParameters(targetEPR);
        try {
            Message message = this.parser.parse(xmlFormat);
            ConnectionHub connectionHub = ConnectionHub.getInstance();
            Connection connection = this.getConnection(targetEPR, connectionHub);
            Initiator initiator = connection.getInitiator();
            String timeout = params.get("timeout");
            if (timeout != null) {
                initiator.setTimeoutMillis(Integer.parseInt(timeout));
            } else {
                initiator.setTimeoutMillis(60000);
            }
            returnMsg = initiator.sendAndReceive(message);
            connectionHub.detach(connection);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("HL7 message successfully dispatched to URL " + targetEPR));
                this.log.debug((Object)("Response message received from target EP : " + returnMsg.toString()));
            }
        }
        catch (Exception e) {
            this.handleException("Error while sending an HL7 message", e);
        }
        if (returnMsg != null) {
            this.processResponse(returnMsg, messageContext);
        } else {
            this.handleException("A response not received from the target HL7 endpoint");
        }
    }

    private void processResponse(Message returnMsg, MessageContext messageContext) throws AxisFault {
        try {
            MessageContext rmc = this.createResponseMessageContext(messageContext);
            SOAPEnvelope soapEnvelope = this.createEnvelope(returnMsg);
            rmc.setEnvelope(soapEnvelope);
            AxisEngine.receive((MessageContext)rmc);
        }
        catch (Exception e) {
            this.handleException("Error while processing the response HL7 message", e);
        }
    }

    private Connection getConnection(String targetEPR, ConnectionHub hub) throws AxisFault {
        try {
            URI url = new URI(targetEPR);
            String targetHost = url.getHost();
            int targetPort = url.getPort();
            return hub.attach(targetHost, targetPort, (Parser)new PipeParser(), MinLowerLayerProtocol.class);
        }
        catch (URISyntaxException e) {
            this.handleException("Malformed HL7 URI syntax: " + targetEPR, e);
        }
        catch (HL7Exception e) {
            this.handleException("Error while obtaining HL7 connection to: " + targetEPR, (Exception)((Object)e));
        }
        return null;
    }

    private Map<String, String> getURLParameters(String url) throws AxisFault {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            URI hl7Url = new URI(url);
            String query = hl7Url.getQuery();
            if (query != null) {
                String[] paramStrings;
                for (String p : paramStrings = query.split("&")) {
                    int index = p.indexOf(61);
                    params.put(p.substring(0, index), p.substring(index + 1));
                }
            }
            return params;
        }
        catch (URISyntaxException e) {
            this.handleException("Malformed HL7 url", e);
            return null;
        }
    }

    private SOAPEnvelope createEnvelope(Message message) throws HL7Exception, XMLStreamException {
        SOAPFactory fac = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope envelope = fac.getDefaultEnvelope();
        OMElement messageEl = HL7Utils.generateHL7MessageElement((String)this.parser.encode(message));
        envelope.getBody().addChild((OMNode)messageEl);
        return envelope;
    }
}

