/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.transport;

import ca.uhn.hl7v2.app.Application;
import ca.uhn.hl7v2.app.SimpleServer;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.base.AbstractTransportListenerEx;
import org.wso2.carbon.business.messaging.hl7.transport.HL7Endpoint;
import org.wso2.carbon.business.messaging.hl7.transport.utils.HL7MessageProcessor;

public class HL7TransportListener
extends AbstractTransportListenerEx<HL7Endpoint> {
    private Map<HL7Endpoint, SimpleServer> serverTable = new HashMap<HL7Endpoint, SimpleServer>();

    protected void doInit() throws AxisFault {
    }

    protected HL7Endpoint createEndpoint() {
        return new HL7Endpoint();
    }

    protected void startEndpoint(HL7Endpoint endpoint) throws AxisFault {
        LowerLayerProtocol llp = LowerLayerProtocol.makeLLP();
        SimpleServer server = new SimpleServer(endpoint.getPort(), llp, (Parser)endpoint.getProcessingContext().getPipeParser());
        HL7MessageProcessor callback = new HL7MessageProcessor(endpoint);
        server.registerApplication("*", "*", (Application)callback);
        server.start();
        this.serverTable.put(endpoint, server);
        this.log.info((Object)("Started HL7 endpoint on port: " + endpoint.getPort()));
    }

    protected void stopEndpoint(HL7Endpoint endpoint) {
        SimpleServer server = this.serverTable.remove((Object)endpoint);
        if (server != null) {
            server.stop();
        }
        this.log.info((Object)("Stopped HL7 endpoint on port: " + endpoint.getPort()));
    }
}

