/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.transport;

import ca.uhn.hl7v2.HL7Exception;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.axis2.transport.base.ProtocolEndpoint;
import org.wso2.carbon.business.messaging.hl7.common.HL7ProcessingContext;

public class HL7Endpoint
extends ProtocolEndpoint {
    private int port = 9792;
    private HL7ProcessingContext processingContext;

    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        if (params instanceof AxisService) {
            this.port = ParamUtils.getOptionalParamInt((ParameterInclude)params, (String)"transport.hl7.Port", (int)-1);
            if (this.port == -1) {
                return false;
            }
            this.processingContext = this.createProcessingContext(params);
            return true;
        }
        return false;
    }

    private HL7ProcessingContext createProcessingContext(ParameterInclude params) throws AxisFault {
        try {
            return new HL7ProcessingContext(params);
        }
        catch (HL7Exception e) {
            throw new AxisFault("Error creating HL7 processing context: " + e.getMessage(), (Throwable)e);
        }
    }

    public HL7ProcessingContext getProcessingContext() {
        return this.processingContext;
    }

    public EndpointReference[] getEndpointReferences(AxisService axisService, String ip) throws AxisFault {
        String url = "hl7://" + ip + ":" + this.port;
        String context = this.getListener().getConfigurationContext().getServiceContextPath();
        if (!context.startsWith("/")) {
            context = "/" + context;
        }
        if (!context.endsWith("/")) {
            context = context + "/";
        }
        url = url + context + axisService.getName();
        return new EndpointReference[]{new EndpointReference(url)};
    }

    public int getPort() {
        return this.port;
    }
}

