/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.business.messaging.hl7.common;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.check.DefaultValidator;
import ca.uhn.hl7v2.conf.parser.ProfileParser;
import ca.uhn.hl7v2.conf.spec.RuntimeProfile;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.v22.message.ACK;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.DefaultValidation;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ParamUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.business.messaging.hl7.common.HL7MessagePreprocessor;
import org.wso2.carbon.business.messaging.hl7.common.HL7Utils;

public class HL7ProcessingContext {
    private Log log = LogFactory.getLog(HL7ProcessingContext.class);
    private boolean autoAck;
    private boolean validateMessage;
    private RuntimeProfile conformanceProfile;
    private PipeParser pipeParser;
    private DefaultValidator defaultValidator;
    private HL7MessagePreprocessor messagePreprocessor;

    public HL7ProcessingContext(boolean autoAck, boolean validateMessage, String conformanceProfileURL, String messagePreprocessorClass) throws HL7Exception {
        this.autoAck = autoAck;
        this.validateMessage = validateMessage;
        if (conformanceProfileURL != null) {
            this.conformanceProfile = this.createConformanceProfile(conformanceProfileURL);
        }
        if (messagePreprocessorClass != null) {
            try {
                this.messagePreprocessor = (HL7MessagePreprocessor)Class.forName(messagePreprocessorClass).newInstance();
            }
            catch (Exception e) {
                throw new HL7Exception("Error creating message preprocessor: " + e.getMessage(), (Throwable)e);
            }
        }
        this.pipeParser = this.getMessagePreprocessor() != null ? new PipeParser(){

            public Message parse(String message) throws HL7Exception {
                message = HL7ProcessingContext.this.getMessagePreprocessor().process(message, "V2X", "ER7");
                return super.parse(message);
            }
        } : new PipeParser();
        this.defaultValidator = new DefaultValidator();
        if (this.isValidateMessage()) {
            this.getPipeParser().setValidationContext((ValidationContext)new DefaultValidation());
        } else {
            this.getPipeParser().setValidationContext((ValidationContext)new NoValidation());
        }
    }

    public HL7ProcessingContext(ParameterInclude params) throws HL7Exception, AxisFault {
        this(ParamUtils.getOptionalParamBoolean((ParameterInclude)params, (String)"transport.hl7.AutoAck", (boolean)true), ParamUtils.getOptionalParamBoolean((ParameterInclude)params, (String)"transport.hl7.ValidateMessage", (boolean)true), ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.hl7.ConformanceProfilePath"), ParamUtils.getOptionalParam((ParameterInclude)params, (String)"transport.hl7.MessagePreprocessorClass"));
    }

    public HL7ProcessingContext(AxisService service) throws HL7Exception {
        this(HL7ProcessingContext.extractServiceBooleanParam(service, "transport.hl7.AutoAck", true), HL7ProcessingContext.extractServiceBooleanParam(service, "transport.hl7.ValidateMessage", true), HL7ProcessingContext.extractServiceStringParam(service, "transport.hl7.ConformanceProfilePath"), HL7ProcessingContext.extractServiceStringParam(service, "transport.hl7.MessagePreprocessorClass"));
    }

    public HL7MessagePreprocessor getMessagePreprocessor() {
        return this.messagePreprocessor;
    }

    private static boolean extractServiceBooleanParam(AxisService service, String name, boolean defaultVal) {
        Object value;
        Parameter param;
        if (service != null && (param = service.getParameter(name)) != null && (value = param.getValue()) != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return defaultVal;
    }

    private static String extractServiceStringParam(AxisService service, String name) {
        Object value;
        Parameter param;
        if (service != null && (param = service.getParameter(name)) != null && (value = param.getValue()) != null) {
            return value.toString();
        }
        return null;
    }

    private Message createDefaultNackMessage(String errorMsg) throws DataTypeException {
        ACK ack = new ACK();
        ack.getMSH().getFieldSeparator().setValue("|");
        ack.getMSH().getEncodingCharacters().setValue("^~\\&");
        ack.getMSH().getReceivingApplication().setValue(" ");
        ack.getMSH().getReceivingFacility().setValue(" ");
        ack.getMSH().getProcessingID().setValue("P");
        ack.getMSA().getAcknowledgementCode().setValue("AR");
        ack.getMSA().getMessageControlID().setValue("123456789");
        ack.getERR().getErrorCodeAndLocation(0).getCodeIdentifyingError().getIdentifier().setValue(errorMsg);
        return ack;
    }

    public DefaultValidator getDefaultValidator() {
        return this.defaultValidator;
    }

    private RuntimeProfile createConformanceProfile(String conformanceProfileURL) throws HL7Exception {
        InputStream in = null;
        try {
            RuntimeProfile profile;
            in = new URL(conformanceProfileURL).openStream();
            RuntimeProfile runtimeProfile = profile = new ProfileParser(false).parse(HL7Utils.streamToString(in));
            return runtimeProfile;
        }
        catch (Exception e) {
            throw new HL7Exception("Error creating conformance profile: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    this.log.error((Object)e);
                }
            }
        }
    }

    public PipeParser getPipeParser() {
        return this.pipeParser;
    }

    public boolean isAutoAck() {
        return this.autoAck;
    }

    public boolean isValidateMessage() {
        return this.validateMessage;
    }

    public RuntimeProfile getConformanceProfile() {
        return this.conformanceProfile;
    }

    public Message parseMessage(String hl7TextMsg) throws HL7Exception, ProfileException {
        return this.getPipeParser().parse(hl7TextMsg);
    }

    public void checkConformanceProfile(Message message) throws HL7Exception {
        RuntimeProfile profile = this.getConformanceProfile();
        if (profile != null) {
            try {
                Object[] errors = this.getDefaultValidator().validate(message, profile.getMessage());
                throw new HL7Exception(Arrays.toString(errors), 200);
            }
            catch (ProfileException e) {
                throw new HL7Exception(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void initMessageContext(Message message, MessageContext msgCtx) {
        msgCtx.setProperty("HL7_MESSAGE_OBJECT", (Object)message);
    }

    public Message createAck(Message hl7Msg) throws HL7Exception {
        try {
            return hl7Msg.generateACK();
        }
        catch (IOException e) {
            throw new HL7Exception((Throwable)e);
        }
    }

    public Message createNack(Message hl7Msg, String errorMsg) throws HL7Exception {
        if (errorMsg == null) {
            errorMsg = "";
        }
        if (hl7Msg == null) {
            return this.createDefaultNackMessage(errorMsg);
        }
        try {
            return hl7Msg.generateACK("AE", new HL7Exception(errorMsg));
        }
        catch (IOException e) {
            throw new HL7Exception((Throwable)e);
        }
    }

    public Message handleHL7Result(MessageContext ctx, Message hl7Msg) throws HL7Exception {
        String resultMode = (String)ctx.getProperty("HL7_RESULT_MODE");
        if (resultMode != null) {
            if ("ACK".equals(resultMode)) {
                return this.createAck(hl7Msg);
            }
            if ("NACK".equals(resultMode)) {
                String nackMessage = (String)ctx.getProperty("HL7_NACK_MESSAGE");
                if (nackMessage == null) {
                    nackMessage = "";
                }
                return this.createNack(hl7Msg, nackMessage);
            }
        } else if (this.isAutoAck()) {
            return this.createAck(hl7Msg);
        }
        return this.createNack(hl7Msg, "Application Error: ACK/NACK was not explicitely returned");
    }
}

