/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.vfs.internal;

import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.transports.TransportAxis2ConfigurationContextObserver;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.transport.vfs.VFSTransportService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class VFSTransportServiceComponent {
    private static Log log = LogFactory.getLog(VFSTransportServiceComponent.class);
    private ConfigurationContextService contextService;

    protected void activate(ComponentContext ctxt) {
        log.debug((Object)"******* VFS Transport bundle is activated ******* ");
        try {
            if (this.contextService == null) {
                throw new Exception("ConfigurationContext is not found while loading org.wso2.carbon.transport.vfs bundle");
            }
            ConfigurationContext configContext = this.contextService.getServerConfigContext();
            BundleContext bundleCtx = ctxt.getBundleContext();
            URL configURL = bundleCtx.getBundle().getResource("vfs-transports.xml");
            new TransportPersistenceManager(configContext.getAxisConfiguration()).saveTransportConfiguration("vfs", configURL);
            TransportAxis2ConfigurationContextObserver cfgCtxObserver = new TransportAxis2ConfigurationContextObserver("vfs", configURL);
            bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)cfgCtxObserver, null);
            VFSTransportService vfsTransport = new VFSTransportService();
            Properties props = new Properties();
            bundleCtx.registerService(TransportService.class.getName(), (Object)vfsTransport, (Dictionary)props);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully registered the vfs transport service");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while initializing VFS transport management bundle", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"******* VFS Transport bundle is deactivated ******* ");
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = null;
    }
}

