/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.nhttp.api;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.synapse.transport.nhttp.DefaultHttpGetProcessor;
import org.apache.synapse.transport.nhttp.ServerHandler;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.w3c.dom.Element;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.core.transports.CarbonHttpRequest;
import org.wso2.carbon.core.transports.CarbonHttpResponse;
import org.wso2.carbon.core.transports.HttpGetRequestProcessor;

public class NHttpGetProcessor
extends DefaultHttpGetProcessor {
    private Map<String, HttpGetRequestProcessor> getRequestProcessors = new LinkedHashMap<String, HttpGetRequestProcessor>();
    private static final QName ITEM_QN = new QName("http://wso2.org/projects/carbon/carbon.xml", "Item");
    private static final QName CLASS_QN = new QName("http://wso2.org/projects/carbon/carbon.xml", "Class");
    private static final Log log = LogFactory.getLog(NHttpGetProcessor.class);

    private void populateGetRequestProcessors() throws AxisFault {
        try {
            OMElement docEle = XMLUtils.toOM((Element)ServerConfiguration.getInstance().getDocumentElement());
            if (docEle != null) {
                SimpleNamespaceContext nsCtx = new SimpleNamespaceContext();
                nsCtx.addNamespace("wsas", "http://wso2.org/projects/carbon/carbon.xml");
                AXIOMXPath xp = new AXIOMXPath("//wsas:HttpGetRequestProcessors/wsas:Processor");
                xp.setNamespaceContext((NamespaceContext)nsCtx);
                List nodeList = xp.selectNodes((Object)docEle);
                for (Object aNodeList : nodeList) {
                    OMElement processorEle = (OMElement)aNodeList;
                    OMElement itemEle = processorEle.getFirstChildWithName(ITEM_QN);
                    if (itemEle == null) {
                        throw new ServletException("Required element, 'Item' not found!");
                    }
                    OMElement classEle = processorEle.getFirstChildWithName(CLASS_QN);
                    if (classEle == null) {
                        throw new ServletException("Required element, 'Class' not found!");
                    }
                    HttpGetRequestProcessor processor = (HttpGetRequestProcessor)Class.forName(classEle.getText().trim()).newInstance();
                    this.getRequestProcessors.put(itemEle.getText().trim(), processor);
                }
            }
        }
        catch (Exception e) {
            this.handleException("Error populating GetRequestProcessors", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWithGetProcessor(HttpRequest request, HttpResponse response, String requestUri, String requestUrl, String queryString, String item, OutputStream outputStream, NHttpServerConnection conn) throws Exception {
        OverflowBlob temporaryData = new OverflowBlob(256, 4048, "_nhttp", ".dat");
        try {
            CarbonHttpRequest carbonHttpRequest = new CarbonHttpRequest("GET", requestUri, requestUrl);
            String uri = request.getRequestLine().getUri();
            int pos = uri.indexOf("?");
            if (pos != -1) {
                StringTokenizer st = new StringTokenizer(uri.substring(pos + 1), "&");
                while (st.hasMoreTokens()) {
                    String param = st.nextToken();
                    pos = param.indexOf("=");
                    if (pos != -1) {
                        carbonHttpRequest.setParameter(param.substring(0, pos), param.substring(pos + 1));
                        continue;
                    }
                    carbonHttpRequest.setParameter(param, null);
                }
            }
            carbonHttpRequest.setContextPath(this.cfgCtx.getServiceContextPath());
            carbonHttpRequest.setQueryString(queryString);
            CarbonHttpResponse carbonHttpResponse = new CarbonHttpResponse((OutputStream)temporaryData.getOutputStream());
            this.getRequestProcessors.get(item).process(carbonHttpRequest, carbonHttpResponse, this.cfgCtx);
            Map responseHeaderMap = carbonHttpResponse.getHeaders();
            for (String key : responseHeaderMap.keySet()) {
                Object value = responseHeaderMap.get(key);
                response.addHeader(key.toString(), value.toString());
            }
            response.setStatusCode(carbonHttpResponse.getStatusCode());
            if (carbonHttpResponse.isError()) {
                if (carbonHttpResponse.getStatusMessage() != null) {
                    response.setStatusLine(response.getProtocolVersion(), carbonHttpResponse.getStatusCode(), carbonHttpResponse.getStatusMessage());
                } else {
                    response.setStatusLine(response.getProtocolVersion(), carbonHttpResponse.getStatusCode());
                }
            }
            if (carbonHttpResponse.isRedirect()) {
                response.addHeader("Location", carbonHttpResponse.getRedirect());
                response.setStatusLine(response.getProtocolVersion(), 302);
            }
            this.serverHandler.commitResponseHideExceptions(conn, response);
            temporaryData.writeTo(outputStream);
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        finally {
            temporaryData.release();
        }
    }

    public void init(ConfigurationContext configurationContext, ServerHandler serverHandler) throws AxisFault {
        super.init(configurationContext, serverHandler);
        if (this.cfgCtx.getProperty("GETRequestProcessorMap") != null) {
            this.getRequestProcessors = (Map)this.cfgCtx.getProperty("GETRequestProcessorMap");
        } else {
            this.populateGetRequestProcessors();
        }
    }

    public void process(HttpRequest request, HttpResponse response, MessageContext messageContext, NHttpServerConnection conn, OutputStream outputStream, boolean b) {
        boolean isRequestHandled = false;
        String uri = request.getRequestLine().getUri();
        String servicePath = this.cfgCtx.getServiceContextPath();
        if (!servicePath.startsWith("/")) {
            servicePath = "/" + servicePath;
        }
        String serviceName = this.getServiceName(request);
        boolean loadBalancer = Boolean.parseBoolean(System.getProperty("wso2.loadbalancer", "false"));
        if (uri.equals("/favicon.ico")) {
            response.setStatusCode(301);
            response.addHeader("Location", "http://wso2.org/favicon.ico");
            this.serverHandler.commitResponseHideExceptions(conn, response);
            isRequestHandled = true;
        } else if (uri.startsWith(servicePath) && (serviceName == null || serviceName.length() == 0)) {
            if (this.isServiceListBlocked(uri)) {
                response.setStatusCode(403);
                this.serverHandler.commitResponseHideExceptions(conn, response);
            } else {
                this.generateServicesList(response, conn, outputStream, servicePath);
            }
            try {
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            isRequestHandled = true;
        } else {
            int pos = uri.indexOf(63);
            if (pos != -1) {
                String queryString = uri.substring(pos + 1);
                String requestUri = uri.substring(0, pos);
                String requestUrl = uri;
                if (requestUri.indexOf("://") == -1) {
                    HttpInetConnection inetConn = (HttpInetConnection)conn;
                    String hostName = "localhost";
                    ServerConfiguration serverConfig = ServerConfiguration.getInstance();
                    if (serverConfig.getFirstProperty("HostName") != null) {
                        hostName = serverConfig.getFirstProperty("HostName");
                    }
                    requestUrl = "http://" + hostName + ":" + inetConn.getLocalPort() + requestUri;
                }
                String contextPath = this.cfgCtx.getServiceContextPath();
                int beginIndex = -1;
                if (requestUri.indexOf(contextPath) != -1) {
                    beginIndex = requestUri.indexOf(contextPath) + contextPath.length() + 1;
                }
                AxisService axisService = null;
                if (beginIndex >= 0 && beginIndex <= requestUri.length()) {
                    serviceName = requestUri.substring(beginIndex);
                    axisService = this.cfgCtx.getAxisConfiguration().getServiceForActivation(serviceName);
                }
                if (axisService == null && !loadBalancer && serviceName != null) {
                    try {
                        axisService = TenantAxisUtils.getAxisService((String)serviceName, (ConfigurationContext)this.cfgCtx);
                    }
                    catch (AxisFault axisFault) {
                        axisFault.printStackTrace();
                    }
                }
                if (queryString != null) {
                    for (String item : this.getRequestProcessors.keySet()) {
                        if (queryString.indexOf(item) != 0 || !queryString.equals(item) && queryString.indexOf("&") != item.length() && queryString.indexOf("=") != item.length() || axisService == null) continue;
                        try {
                            this.processWithGetProcessor(request, response, requestUri, requestUrl, queryString, item, outputStream, conn);
                        }
                        catch (Exception e) {
                            this.handleBrowserException(response, conn, outputStream, "Error processing request", e);
                        }
                        isRequestHandled = true;
                        break;
                    }
                }
            }
        }
        if (!isRequestHandled) {
            this.processGetAndDelete(request, response, messageContext, conn, outputStream, "GET", b);
        }
    }

    public void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

