/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.mgt;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.ServicePersistenceManager;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.core.transports.util.TransportDetails;
import org.wso2.carbon.core.transports.util.TransportParameter;
import org.wso2.carbon.core.transports.util.TransportSummary;
import org.wso2.carbon.service.mgt.ServiceAdmin;
import org.wso2.carbon.transport.mgt.TransportData;
import org.wso2.carbon.transport.mgt.TransportStore;

public class TransportAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(TransportAdmin.class);

    public TransportSummary[] listTransports() {
        TransportStore transportStore = TransportStore.getInstance();
        Map<String, TransportService> transports = transportStore.getAvailableTransports();
        ArrayList<TransportSummary> transCollection = new ArrayList<TransportSummary>();
        for (TransportService transportService : transports.values()) {
            TransportSummary summary = new TransportSummary();
            summary.setProtocol(transportService.getName());
            summary.setListenerActive(transportService.isEnabled(true, this.getAxisConfig()));
            summary.setSenderActive(transportService.isEnabled(false, this.getAxisConfig()));
            transCollection.add(summary);
        }
        return transCollection.toArray(new TransportSummary[transCollection.size()]);
    }

    public TransportSummary[] listTransportsForService(String serviceName) throws Exception {
        if (serviceName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid service name");
            }
            throw new Exception("Invalid service name");
        }
        TransportStore transportStore = TransportStore.getInstance();
        Map<String, TransportService> transports = transportStore.getAvailableTransports();
        ArrayList<TransportSummary> transCollection = new ArrayList<TransportSummary>();
        boolean isUTEnabled = this.isUTEnabled(serviceName);
        for (TransportService transportService : transports.values()) {
            TransportSummary summary = new TransportSummary();
            summary.setProtocol(transportService.getName());
            summary.setListenerActive(transportService.isEnabled(true, this.getAxisConfig()));
            summary.setSenderActive(transportService.isEnabled(false, this.getAxisConfig()));
            if (!summary.isListenerActive()) continue;
            if (isUTEnabled) {
                if (!"https".equalsIgnoreCase(transportService.getName())) continue;
                transCollection.add(summary);
                continue;
            }
            transCollection.add(summary);
        }
        return transCollection.toArray(new TransportSummary[transCollection.size()]);
    }

    public TransportSummary[] listExposedTransports(String serviceName) throws Exception {
        String[] exposedTransports;
        if (serviceName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid service name");
            }
            throw new Exception("Invalid service name");
        }
        boolean isUTEnabled = this.isUTEnabled(serviceName);
        try {
            ServiceAdmin admin = new ServiceAdmin(this.getAxisConfig());
            exposedTransports = admin.getExposedTransports(serviceName);
        }
        catch (Exception e) {
            throw new AxisFault("error while adding exposed transport", (Throwable)e);
        }
        ArrayList<TransportSummary> transCollection = new ArrayList<TransportSummary>();
        for (int i = 0; i < exposedTransports.length; ++i) {
            String transport = exposedTransports[i];
            boolean isActive = false;
            if (this.getAxisConfig().getTransportIn(transport) != null) {
                isActive = true;
            }
            TransportSummary summary = new TransportSummary();
            summary.setProtocol(transport);
            summary.setListenerActive(isActive);
            summary.setSenderActive(this.getAxisConfig().getTransportOut(transport) != null);
            if (isUTEnabled && "https".equalsIgnoreCase(transport)) {
                summary.setNonRemovable(true);
            }
            if (!isActive) continue;
            transCollection.add(summary);
        }
        return transCollection.toArray(new TransportSummary[transCollection.size()]);
    }

    public TransportData[] getAllTransportData() throws Exception {
        TransportData[] transportData;
        try {
            TransportSummary[] summary = this.listTransports();
            transportData = new TransportData[summary.length];
            for (int i = 0; i < summary.length; ++i) {
                TransportSummary transportSummary = summary[i];
                TransportDetails details = this.getTransportDetails(transportSummary.getProtocol());
                TransportData data = new TransportData();
                data.setDetails(details);
                data.setSummary(transportSummary);
                transportData[i] = data;
            }
        }
        catch (Exception e) {
            throw new AxisFault("Error while retrieving transport data", (Throwable)e);
        }
        return transportData;
    }

    public void addExposedTransports(String serviceName, String transport) throws Exception {
        if (serviceName == null) {
            this.handleException("Invalid service name: Service name must not be null");
        }
        if (transport == null) {
            this.handleException("Invalid transport name: Transport name must not be null");
        }
        try {
            ServiceAdmin admin = new ServiceAdmin(this.getAxisConfig());
            admin.addTransportBinding(serviceName, transport);
        }
        catch (Exception e) {
            this.handleException("Error while adding exposed transport " + transport, e);
        }
    }

    public void removeExposedTransports(String serviceName, String transportProtocol) throws Exception {
        AxisService axisService;
        PersistenceFactory pf = PersistenceFactory.getInstance((AxisConfiguration)this.getAxisConfig());
        if (serviceName == null) {
            this.handleException("Invalid service name");
        }
        if (transportProtocol == null) {
            this.handleException("Invalid transport name");
        }
        if ((axisService = this.getAxisConfig().getServiceForActivation(serviceName)) == null) {
            this.handleException("No service exists by the name : " + serviceName);
        }
        try {
            if (this.isUTEnabled(serviceName) && "https".equalsIgnoreCase(transportProtocol)) {
                throw new Exception("Cannot remove HTTPS transport binding for Service [" + serviceName + "] since a security scenario which requires the " + "service to contain only the HTTPS transport binding" + " has been applied to this service.");
            }
            if (!axisService.isEnableAllTransports()) {
                if (axisService.getExposedTransports().size() == 1) {
                    log.warn((Object)"At least one transport binding must exist for a service. No bindings will be removed.");
                    return;
                }
                axisService.removeExposedTransport(transportProtocol);
            } else {
                TransportSummary[] transports;
                for (TransportSummary transport : transports = this.listTransports()) {
                    if (!transport.isListenerActive() || transport.getProtocol().equals(transportProtocol)) continue;
                    axisService.addExposedTransport(transport.getProtocol());
                }
                axisService.setEnableAllTransports(false);
            }
            ServicePersistenceManager pm = pf.getServicePM();
            pm.removeExposedTransports(serviceName, transportProtocol);
            this.getAxisConfig().notifyObservers(new AxisEvent(101, (AxisDescription)axisService), axisService);
        }
        catch (Exception e) {
            this.handleException("Error while removing exposed transport : " + transportProtocol, e);
        }
    }

    private void handleException(String msg) throws Exception {
        log.error((Object)msg);
        throw new Exception(msg);
    }

    private void handleException(String msg, Throwable t) throws Exception {
        log.error((Object)msg, t);
        throw new Exception(msg, t);
    }

    public TransportDetails getTransportDetails(String transportProtocol) throws Exception {
        if (transportProtocol == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Invalid transport name");
            }
            throw new Exception("Invalid transport name");
        }
        TransportService transportService = TransportStore.getInstance().getTransport(transportProtocol);
        if (transportService != null) {
            TransportDetails details = new TransportDetails();
            details.setListenerActive(transportService.isEnabled(true, this.getAxisConfig()));
            details.setSenderActive(transportService.isEnabled(false, this.getAxisConfig()));
            details.setInParameters(transportService.getGlobalTransportParameters(true, this.getAxisConfig()));
            details.setOutParameters(transportService.getGlobalTransportParameters(false, this.getAxisConfig()));
            return details;
        }
        log.warn((Object)("Transport service not available for : " + transportProtocol));
        return null;
    }

    public TransportParameter[] getGloballyDefinedInParameters(String transport) throws Exception {
        TransportService service = TransportStore.getInstance().getTransport(transport);
        if (service != null) {
            return service.getGlobalTransportParameters(true, this.getAxisConfig());
        }
        return null;
    }

    public TransportParameter[] getGloballyDefinedOutParameters(String transport) throws Exception {
        TransportService service = TransportStore.getInstance().getTransport(transport);
        if (service != null) {
            return service.getGlobalTransportParameters(false, this.getAxisConfig());
        }
        return null;
    }

    public void updateGloballyDefinedInParameters(String transport, TransportParameter[] params) throws Exception {
        TransportService service = TransportStore.getInstance().getTransport(transport);
        if (service == null) {
            throw new Exception("Transport management service is not available for : " + transport);
        }
        service.updateGlobalTransportParameters(params, true, this.getConfigContext());
    }

    public void updateGloballyDefinedOutParameters(String transport, TransportParameter[] params) throws Exception {
        TransportService service = TransportStore.getInstance().getTransport(transport);
        if (service == null) {
            throw new Exception("Transport management service is not available for : " + transport);
        }
        service.updateGlobalTransportParameters(params, false, this.getConfigContext());
    }

    public TransportParameter[] getServiceSpecificInParameters(String transport, String service) throws Exception {
        TransportService trpService = TransportStore.getInstance().getTransport(transport);
        if (service != null) {
            return trpService.getServiceLevelTransportParameters(service, true, this.getAxisConfig());
        }
        return null;
    }

    public TransportParameter[] getServiceSpecificOutParameters(String transport, String service) throws Exception {
        TransportService trpService = TransportStore.getInstance().getTransport(transport);
        if (service != null) {
            return trpService.getServiceLevelTransportParameters(service, false, this.getAxisConfig());
        }
        return null;
    }

    public void updateServiceSpecificInParameters(String transport, String service, TransportParameter[] params) throws Exception {
        TransportService trpService = TransportStore.getInstance().getTransport(transport);
        if (trpService == null) {
            throw new Exception("Transport management service is not available for : " + transport);
        }
        trpService.updateServiceLevelTransportParameters(service, params, true, this.getConfigContext());
    }

    public void updateServiceSpecificOutParameters(String transport, String service, TransportParameter[] params) throws Exception {
        TransportService trpService = TransportStore.getInstance().getTransport(transport);
        if (trpService == null) {
            throw new Exception("Transport management service is not available for : " + transport);
        }
        trpService.updateServiceLevelTransportParameters(service, params, false, this.getConfigContext());
    }

    public void disableListener(String transport) throws Exception {
        TransportService trpService = TransportStore.getInstance().getTransport(transport);
        if (trpService != null) {
            trpService.disableTransport(true, this.getAxisConfig());
        }
    }

    public void disableSender(String transport) throws Exception {
        TransportService trpService = TransportStore.getInstance().getTransport(transport);
        if (trpService != null) {
            trpService.disableTransport(false, this.getAxisConfig());
        }
    }

    public boolean dependenciesAvailable(String transport, TransportParameter[] params) throws Exception {
        TransportService trpService = TransportStore.getInstance().getTransport(transport);
        if (trpService == null) {
            throw new Exception("The transport management service for " + transport + " is not" + " available in the transport store");
        }
        return trpService.dependenciesAvailable(params);
    }

    private boolean isUTEnabled(String serviceName) throws AxisFault {
        AxisService axisService = this.getAxisConfig().getServiceForActivation(serviceName);
        try {
            ServicePersistenceManager pm = PersistenceFactory.getInstance((AxisConfiguration)this.getAxisConfig()).getServicePM();
            OMElement serviceElement = pm.getService(axisService);
            if (serviceElement == null) {
                pm.handleNewServiceAddition(axisService);
                serviceElement = pm.getService(axisService);
            }
            if (serviceElement.getAttributeValue(new QName("utEnabled")) != null) {
                return true;
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred while checking whether UT being enabled for service " + serviceName), (Throwable)e);
            return false;
        }
        return false;
    }
}

