/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.mgt.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.transport.mgt.TransportStore;
import org.wso2.carbon.utils.ConfigurationContextService;

public class TransportMgtServiceComponent {
    private static Log log = LogFactory.getLog(TransportMgtServiceComponent.class);
    private AxisConfiguration axisConfig = null;
    private List<TransportService> trpList = new ArrayList<TransportService>();

    protected void activate(ComponentContext ctxt) {
        log.debug((Object)"******* Transport mgt bundle is activated ******* ");
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"******* Transport mgt bundle is deactivated ******* ");
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.axisConfig = contextService.getServerConfigContext().getAxisConfiguration();
        TransportStore trpStore = TransportStore.getInstance();
        for (TransportService trpService : this.trpList) {
            trpStore.addTransport(trpService.getName(), trpService, this.axisConfig);
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.axisConfig = null;
    }

    protected void addTransportService(TransportService trpService) {
        if (this.axisConfig == null) {
            this.trpList.add(trpService);
        } else {
            TransportStore.getInstance().addTransport(trpService.getName(), trpService, this.axisConfig);
        }
    }

    protected void removeTransportService(TransportService trpService) {
        if (this.axisConfig == null) {
            this.trpList.remove(trpService);
        } else {
            TransportStore.getInstance().removeTransport(trpService.getName());
        }
    }
}

