/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.mgt;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.transports.TransportService;

public class TransportStore {
    private Map<String, TransportService> transportStore = new HashMap<String, TransportService>();
    private static final Log log = LogFactory.getLog(TransportStore.class);
    private static final TransportStore INSTANCE = new TransportStore();

    private TransportStore() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Initialized the singleton transport store INSTANCE");
        }
    }

    public static TransportStore getInstance() {
        return INSTANCE;
    }

    public void addTransport(String name, TransportService transportService, AxisConfiguration axisConfig) {
        if (!transportService.isEnabled(true, axisConfig) && !transportService.isAvailable(true, axisConfig)) {
            return;
        }
        if (!transportService.isEnabled(false, axisConfig) && !transportService.isAvailable(false, axisConfig)) {
            return;
        }
        if (!this.transportStore.containsKey(name)) {
            this.transportStore.put(name, transportService);
            if (log.isDebugEnabled()) {
                log.debug((Object)(name + " transport added to the transport store and will be available " + "via the management console"));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Transport already exists " + name));
        }
    }

    public void removeTransport(String name) {
        TransportService trpService = this.transportStore.remove(name);
        if (trpService != null && log.isDebugEnabled()) {
            log.debug((Object)(name + " transport removed from the transport store and will not be " + "available via the management console"));
        }
    }

    public Map<String, TransportService> getAvailableTransports() {
        return Collections.unmodifiableMap(this.transportStore);
    }

    public TransportService getTransport(String protocol) {
        return this.transportStore.get(protocol);
    }
}

