/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.mgt.ui;

import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.transport.mgt.stub.TransportAdminStub;
import org.wso2.carbon.transport.mgt.stub.types.carbon.TransportData;
import org.wso2.carbon.transport.mgt.stub.types.carbon.TransportDetails;
import org.wso2.carbon.transport.mgt.stub.types.carbon.TransportParameter;
import org.wso2.carbon.transport.mgt.stub.types.carbon.TransportSummary;

public class TransportAdminClient {
    private static final Log log = LogFactory.getLog(TransportAdminClient.class);
    private TransportAdminStub stub;

    public TransportAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "TransportAdmin";
        this.stub = new TransportAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public TransportSummary[] listTransports() throws AxisFault {
        TransportSummary[] summary = new TransportSummary[]{};
        try {
            summary = this.stub.listTransports();
        }
        catch (Exception e) {
            this.handleException("Error while retriving transport summary", e);
        }
        return summary;
    }

    public TransportSummary[] listTransports(String serviceName) throws AxisFault {
        TransportSummary[] summary = new TransportSummary[]{};
        try {
            summary = this.stub.listTransportsForService(serviceName);
        }
        catch (Exception e) {
            this.handleException("Error while retriving transport summary", e);
        }
        return summary;
    }

    public TransportSummary[] listExposedTransports(String serviceName) throws AxisFault {
        TransportSummary[] summary = new TransportSummary[]{};
        try {
            summary = this.stub.listExposedTransports(serviceName);
            if (summary == null || summary.length == 0 || summary[0] == null) {
                return null;
            }
        }
        catch (Exception e) {
            this.handleException("Error while retreiving exposed transports for service " + serviceName, e);
        }
        return summary;
    }

    public void addExposedTransports(String serviceName, String transport) throws AxisFault {
        try {
            this.stub.addExposedTransports(serviceName, transport);
        }
        catch (Exception e) {
            this.handleException("Error while adding exposed transports for service " + serviceName, e);
        }
    }

    public void removeExposedTransports(String serviceName, String transport) throws AxisFault {
        try {
            this.stub.removeExposedTransports(serviceName, transport);
        }
        catch (Exception e) {
            this.handleException("Error while removing exposed transports for service " + serviceName, e);
        }
    }

    public TransportData[] getAllTransportData() throws AxisFault {
        TransportData[] data = new TransportData[]{};
        try {
            data = this.stub.getAllTransportData();
        }
        catch (Exception e) {
            this.handleException("Error while retriving transport data ", e);
        }
        return data;
    }

    public TransportDetails getTransportDetails(String transportProtocol) throws AxisFault {
        TransportDetails details = null;
        try {
            details = this.stub.getTransportDetails(transportProtocol);
        }
        catch (Exception e) {
            this.handleException("Error while retriving transport details for " + transportProtocol, e);
        }
        return details;
    }

    public TransportParameter[] getGloballyDefinedInParameters(String transport) throws AxisFault {
        TransportParameter[] parameters = new TransportParameter[]{};
        try {
            parameters = this.stub.getGloballyDefinedInParameters(transport);
        }
        catch (Exception e) {
            this.handleException("Error while retreiving transport listener parameters for " + transport, e);
        }
        if (parameters == null || parameters.length == 0 || parameters[0] == null) {
            return null;
        }
        return parameters;
    }

    public TransportParameter[] getGloballyDefinedOutParameters(String transport) throws AxisFault {
        TransportParameter[] parameters = new TransportParameter[]{};
        try {
            parameters = this.stub.getGloballyDefinedOutParameters(transport);
        }
        catch (Exception e) {
            this.handleException("Error while retreiving transport sender parameters for " + transport, e);
        }
        if (parameters == null || parameters.length == 0 || parameters[0] == null) {
            return null;
        }
        return parameters;
    }

    public TransportParameter[] getServiceSpecificInParameters(String transport, String service) throws AxisFault {
        TransportParameter[] parameters = new TransportParameter[]{};
        try {
            parameters = this.stub.getServiceSpecificInParameters(transport, service);
        }
        catch (Exception e) {
            this.handleException("Error while retreiving service specific transport listener parameters; Transport: " + transport + ", Service: " + service, e);
        }
        return parameters;
    }

    public TransportParameter[] getServiceSpecificOutParameters(String transport, String service) throws AxisFault {
        TransportParameter[] parameters = new TransportParameter[]{};
        try {
            parameters = this.stub.getServiceSpecificOutParameters(transport, service);
        }
        catch (Exception e) {
            this.handleException("Error while retreiving service specific transport sender parameters; Transport: " + transport + ", Service: " + service, e);
        }
        return parameters;
    }

    public void updateGloballyDefinedInParameters(String transport, TransportParameter[] params) throws AxisFault {
        try {
            this.stub.updateGloballyDefinedInParameters(transport, params);
        }
        catch (Exception e) {
            this.handleException("Error while updating parameters for " + transport + " listener", e);
        }
    }

    public void updateGloballyDefinedOutParameters(String transport, TransportParameter[] params) throws AxisFault {
        try {
            this.stub.updateGloballyDefinedOutParameters(transport, params);
        }
        catch (Exception e) {
            this.handleException("Error while updating parameters for " + transport + " transport sender", e);
        }
    }

    public void updateServiceSpecificInParameters(String transport, String service, TransportParameter[] params) throws AxisFault {
        try {
            this.stub.updateServiceSpecificInParameters(transport, service, params);
        }
        catch (Exception e) {
            this.handleException("Error while updating service specific transport listener parameters; Transport: " + transport + ", Service: " + service, e);
        }
    }

    public void updateServiceSpecificOutParameters(String transport, String service, TransportParameter[] params) throws AxisFault {
        try {
            this.stub.updateServiceSpecificOutParameters(transport, service, params);
        }
        catch (Exception e) {
            this.handleException("Error while updating service specific transport sender parameters; Transport: " + transport + ", Service: " + service, e);
        }
    }

    public void disableListener(String transport) throws AxisFault {
        try {
            this.stub.disableListener(transport);
        }
        catch (Exception e) {
            this.handleException("Error while disabling the " + transport + " transport listener", e);
        }
    }

    public void disableSender(String transport) throws AxisFault {
        try {
            this.stub.disableSender(transport);
        }
        catch (Exception e) {
            this.handleException("Error while disabling the " + transport + " transport sender", e);
        }
    }

    public void enableListener(String transport, TransportParameter[] inParams) throws AxisFault {
        try {
            if (this.stub.dependenciesAvailable(transport, inParams)) {
                if (inParams != null) {
                    this.stub.updateGloballyDefinedInParameters(transport, inParams);
                } else {
                    this.stub.updateGloballyDefinedInParameters(transport, new TransportParameter[0]);
                }
            }
        }
        catch (Exception e) {
            this.handleException("Error while enabling the " + transport + " transport listener", e);
        }
    }

    public void enableSender(String transport, TransportParameter[] outParams) throws AxisFault {
        try {
            if (this.stub.dependenciesAvailable(transport, outParams)) {
                if (outParams != null) {
                    this.stub.updateGloballyDefinedOutParameters(transport, outParams);
                } else {
                    this.stub.updateGloballyDefinedOutParameters(transport, new TransportParameter[0]);
                }
            }
        }
        catch (Exception e) {
            this.handleException("Error while enabling the " + transport + " transport sender", e);
        }
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

