/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.http.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.transport.http.HTTPTransportService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class HTTPTransportServiceComponent {
    private static Log log = LogFactory.getLog(HTTPTransportServiceComponent.class);
    private ConfigurationContextService contextService;

    protected void activate(ComponentContext ctxt) {
        log.debug((Object)"******* HTTP Transport bundle is activated ******* ");
        Properties props = new Properties();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting the http transport component ...");
        }
        try {
            if (this.contextService == null) {
                throw new Exception("ConfigurationContext is not found while loading org.wso2.carbon.transport.http bundle");
            }
            ConfigurationContext configContext = this.contextService.getServerConfigContext();
            HTTPTransportService httpTransport = new HTTPTransportService();
            ctxt.getBundleContext().registerService(TransportService.class.getName(), (Object)httpTransport, (Dictionary)props);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully registered the https transport service");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while activating the HTTP transport management bundle", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"******* HTTP Transport bundle is deactivated ******* ");
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = null;
    }
}

