/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms.internal;

import java.net.URL;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.transports.TransportAxis2ConfigurationContextObserver;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.transport.jms.JMSServiceHolder;
import org.wso2.carbon.transport.jms.JMSTransportService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class JMSTransportServiceComponent {
    private static Log log = LogFactory.getLog(JMSTransportServiceComponent.class);
    private ConfigurationContextService contextService;
    public static final String TRANSPORT_NAME = "jms";
    public static final String TRANSPORT_CONF = "jms-transports.xml";

    protected void activate(ComponentContext ctxt) {
        log.debug((Object)"******* JMS Transport bundle is activated ******* ");
        try {
            if (this.contextService == null) {
                throw new Exception("ConfigurationContext is not found while loading org.wso2.carbon.transport.jms bundle");
            }
            ConfigurationContext configContext = this.contextService.getServerConfigContext();
            BundleContext bundleCtx = ctxt.getBundleContext();
            URL configURL = bundleCtx.getBundle().getResource(TRANSPORT_CONF);
            new TransportPersistenceManager(configContext.getAxisConfiguration()).saveTransportConfiguration(TRANSPORT_NAME, configURL);
            TransportAxis2ConfigurationContextObserver cfgCtxObserver = new TransportAxis2ConfigurationContextObserver(TRANSPORT_NAME, configURL);
            bundleCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)cfgCtxObserver, null);
            JMSTransportService jmsTransport = new JMSTransportService();
            JMSServiceHolder.getInstance().setService((TransportService)jmsTransport);
            Properties props = new Properties();
            bundleCtx.registerService(TransportService.class.getName(), (Object)jmsTransport, (Dictionary)props);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully registered the jms transport service");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while activating JMS transport management bundle", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"******* JMS Transport bundle is deactivated ******* ");
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = null;
    }
}

