/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.jms;

import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.core.transports.util.TransportParameter;
import org.wso2.carbon.transport.jms.JMSServiceHolder;

public class JMSTransportAdmin
extends AbstractAdmin {
    private static final String CONNECTION_FACTORY = "transport.jms.ConnectionFactory";
    private static final String CONNECTION_FACTORY_DEFAULT = "default";
    public static final String TRANSPORT_NAME = "jms";
    public static final String TRANSPORT_CONF = "jms-transports.xml";
    private static final Log log = LogFactory.getLog(JMSTransportAdmin.class);

    public JMSTransportAdmin() {
        this.axisConfig = this.getAxisConfig();
    }

    public TransportParameter[] getServiceSpecificInParameters(String serviceName) throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        TransportParameter[] params = trpService.getServiceLevelTransportParameters(serviceName, true, this.getAxisConfig());
        AxisService service = this.axisConfig.getServiceForActivation(serviceName);
        String factoryName = service.getParameter(CONNECTION_FACTORY) == null ? CONNECTION_FACTORY_DEFAULT : service.getParameter(CONNECTION_FACTORY).getValue().toString();
        for (TransportParameter transportParameter : params) {
            if (!factoryName.equals(transportParameter.getName())) continue;
            TransportParameter[] tempParams = new TransportParameter[]{transportParameter};
            return tempParams;
        }
        return params;
    }

    public TransportParameter[] getServiceSpecificOutParameters(String serviceName) throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        return trpService.getServiceLevelTransportParameters(serviceName, false, this.getAxisConfig());
    }

    public void updateGloballyDefinedInParameters(TransportParameter[] inParams) throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        if (trpService.dependenciesAvailable(inParams)) {
            trpService.updateGlobalTransportParameters(inParams, true, this.getConfigContext());
        } else {
            log.warn((Object)"Initial factory class cannot be found");
        }
    }

    public void updateGloballyDefinedOutParameters(TransportParameter[] outParams) throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        if (outParams == null || trpService.dependenciesAvailable(outParams)) {
            trpService.updateGlobalTransportParameters(outParams, true, this.getConfigContext());
        } else {
            log.warn((Object)"Initial factory class cannot be found");
        }
    }

    public void disableTransportListener() throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        trpService.disableTransport(true, this.getAxisConfig());
    }

    public void disableTransportSender() throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        trpService.disableTransport(false, this.getAxisConfig());
    }

    public void updateServiceSpecificInParameters(String serviceName, TransportParameter[] inParams) throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        if (trpService.dependenciesAvailable(inParams)) {
            trpService.updateServiceLevelTransportParameters(serviceName, inParams, true, this.getConfigContext());
        } else {
            log.warn((Object)"Initial factory class cannot be found");
        }
    }

    public void updateServiceSpecificOutParameters(String serviceName, TransportParameter[] outParams) throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        if (outParams == null || trpService.dependenciesAvailable(outParams)) {
            trpService.updateServiceLevelTransportParameters(serviceName, outParams, false, this.getConfigContext());
        } else {
            log.warn((Object)"Initial factory class cannot be found");
        }
    }

    public TransportParameter[] getGloballyDefinedInParameters() throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        return trpService.getGlobalTransportParameters(true, this.getAxisConfig());
    }

    public TransportParameter[] getGloballyDefinedOutParameters() throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        return trpService.getGlobalTransportParameters(false, this.getAxisConfig());
    }

    public void addConnectionFactory(TransportParameter parameter, String service, boolean listener) throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        trpService.addTransportParameter(parameter, listener, this.getConfigContext());
    }

    public void removeConnectionFactory(String factoryName, String service, boolean listener) throws Exception {
        TransportService trpService = JMSServiceHolder.getInstance().getService();
        trpService.removeTransportParameter(factoryName, listener, this.getConfigContext());
    }
}

