/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transport.https.internal;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.core.transports.TransportService;
import org.wso2.carbon.transport.https.HTTPSTransportService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class HTTPSTransportServiceComponent {
    private static Log log = LogFactory.getLog(HTTPSTransportServiceComponent.class);
    private ConfigurationContextService contextService;

    protected void activate(ComponentContext ctxt) {
        log.debug((Object)"******* HTTPS Transport bundle is activated ******* ");
        Properties props = new Properties();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting the http transport component ...");
        }
        try {
            if (this.contextService == null) {
                throw new Exception("ConfigurationContext is not found while loading org.wso2.carbon.transport.https bundle");
            }
            ConfigurationContext configContext = this.contextService.getServerConfigContext();
            HTTPSTransportService httpsTransport = new HTTPSTransportService();
            ctxt.getBundleContext().registerService(TransportService.class.getName(), (Object)httpsTransport, (Dictionary)props);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Successfully registered the https transport service");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while activating the HTTPS transport management bundle", (Throwable)e);
        }
    }

    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"******* HTTPS Transport bundle is deactivated ******* ");
    }

    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        this.contextService = null;
    }
}

