/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tracer.ui;

import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.tracer.stub.TracerAdminStub;
import org.wso2.carbon.tracer.stub.types.carbon.MessagePayload;
import org.wso2.carbon.tracer.stub.types.carbon.TracerServiceInfo;

public class TracerAdminClient {
    private static final Log log = LogFactory.getLog(TracerAdminClient.class);
    public TracerAdminStub stub;
    private static final String BUNDLE = "org.wso2.carbon.tracer.ui.i18n.Resources";
    private final ResourceBundle resourceBundle;

    public TracerAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx, Locale locale) throws AxisFault {
        String serviceURL = backendServerURL + "TracerAdmin";
        this.stub = new TracerAdminStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        this.resourceBundle = ResourceBundle.getBundle(BUNDLE, locale);
    }

    public TracerServiceInfo getMessages(int numberOfMessages, String filter) throws RemoteException {
        try {
            TracerServiceInfo tracerServiceInfo = this.stub.getMessages(numberOfMessages, filter);
            MessagePayload message = tracerServiceInfo.getLastMessage();
            this.escapeHtml(message);
            return tracerServiceInfo;
        }
        catch (Exception e) {
            this.handleException(this.resourceBundle.getString("cannot.get.the.list.of.tracer.messages"), e);
            return null;
        }
    }

    public TracerServiceInfo setMonitoring(String flag) throws RemoteException {
        try {
            return this.stub.setMonitoring(flag);
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.resourceBundle.getString("cannot.set.tracer.monitoring.status"), flag), e);
            return null;
        }
    }

    public void clearAllSoapMessages() throws RemoteException {
        try {
            this.stub.clearAllSoapMessages();
        }
        catch (RemoteException e) {
            this.handleException(this.resourceBundle.getString("cannot.clear.all.soap.messages"), e);
        }
    }

    public MessagePayload getMessage(String serviceName, String operationName, long messageSequence) throws RemoteException {
        try {
            MessagePayload message = this.stub.getMessage(serviceName, operationName, messageSequence);
            this.escapeHtml(message);
            return message;
        }
        catch (Exception e) {
            this.handleException(MessageFormat.format(this.resourceBundle.getString("cannot.get.tracer.message"), messageSequence, serviceName, operationName), e);
            return null;
        }
    }

    private void escapeHtml(MessagePayload message) {
        if (message != null) {
            if (message.getRequest() != null) {
                String req = StringEscapeUtils.escapeHtml((String)this.removeXmlProlog(message.getRequest()));
                message.setRequest(req);
            }
            if (message.getResponse() != null) {
                String resp = StringEscapeUtils.escapeHtml((String)this.removeXmlProlog(message.getResponse()));
                message.setResponse(resp);
            }
        }
    }

    private String removeXmlProlog(String xml) {
        if ((xml = xml.trim()).indexOf("<?xml") == 0) {
            xml = xml.substring(xml.indexOf(">") + 1);
        }
        return xml;
    }

    private void handleException(String msg, Exception e) throws RemoteException {
        log.error((Object)msg, (Throwable)e);
        throw new RemoteException(msg, e);
    }
}

