/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.tomcat.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.catalina.LifecycleException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.tomcat.internal.CarbonTomcat;

public class ServerManager {
    private static Log log = LogFactory.getLog(ServerManager.class);
    private static CarbonTomcat tomcat;
    private InputStream inputStream;
    static ClassLoader bundleCtxtClassLoader;

    public void init() {
        bundleCtxtClassLoader = Thread.currentThread().getContextClassLoader();
        String carbonHome = System.getProperty("carbon.home");
        String catalinaHome = new File(carbonHome).getAbsolutePath() + File.separator + "lib" + File.separator + "tomcat";
        String catalinaXML = new File(carbonHome).getAbsolutePath() + File.separator + "repository" + File.separator + "conf" + File.separator + "tomcat" + File.separator + "catalina-server.xml";
        try {
            this.inputStream = new FileInputStream(new File(catalinaXML));
        }
        catch (FileNotFoundException e) {
            log.error((Object)"could not locate the file catalina-server.xml", (Throwable)e);
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", System.getProperty("carbon.home") + File.separator + "lib" + File.separator + "tomcat");
        }
        tomcat = new CarbonTomcat();
        tomcat.configure(catalinaHome, this.inputStream);
    }

    public synchronized void start() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setContextClassLoader(bundleCtxtClassLoader);
                try {
                    tomcat.start();
                }
                catch (LifecycleException e) {
                    log.error((Object)"tomcat life-cycle exception", (Throwable)e);
                }
            }
        }).start();
    }

    public void stop() {
        try {
            tomcat.stop();
        }
        catch (LifecycleException e) {
            log.error((Object)"Error while stopping tomcat", (Throwable)e);
        }
    }

    CarbonTomcat getTomcatInstance() {
        return tomcat;
    }
}

